"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
var _pipeline_request_flyout = require("./pipeline_request_flyout");
var _pipeline_form_fields = require("./pipeline_form_fields");
var _pipeline_form_error = require("./pipeline_form_error");
var _schema = require("./schema");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultFormValue = Object.freeze({
  name: '',
  description: '',
  processors: [],
  on_failure: [],
  _meta: {}
});
const PipelineForm = ({
  defaultValue = defaultFormValue,
  onSave,
  isSaving,
  saveError,
  isEditing,
  onCancel,
  canEditName
}) => {
  const [isRequestVisible, setIsRequestVisible] = (0, _react.useState)(false);
  const {
    processors: initialProcessors,
    on_failure: initialOnFailureProcessors,
    ...defaultFormValues
  } = defaultValue;
  const [processorsState, setProcessorsState] = (0, _react.useState)({
    processors: initialProcessors,
    onFailure: initialOnFailureProcessors
  });
  const processorStateRef = (0, _react.useRef)();
  const handleSave = async (formData, isValid) => {
    if (!isValid) {
      return;
    }
    if (processorStateRef.current) {
      const state = processorStateRef.current;
      if (await state.validate()) {
        onSave({
          ...formData,
          ...state.getData()
        });
      }
    }
  };
  const {
    form
  } = (0, _shared_imports.useForm)({
    schema: _schema.pipelineFormSchema,
    defaultValue: defaultFormValues,
    onSubmit: handleSave
  });
  const onEditorFlyoutOpen = (0, _react.useCallback)(() => {
    setIsRequestVisible(false);
  }, [setIsRequestVisible]);
  const saveButtonLabel = isSaving ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.form.savingButtonLabel",
    defaultMessage: "Saving..."
  }) : isEditing ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.form.saveButtonLabel",
    defaultMessage: "Save pipeline"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.form.createButtonLabel",
    defaultMessage: "Create pipeline"
  });
  const onProcessorsChangeHandler = (0, _react.useCallback)(arg => processorStateRef.current = arg, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    "data-test-subj": "pipelineForm",
    isInvalid: form.isSubmitted && !form.isValid,
    error: form.getErrors()
  }, saveError && /*#__PURE__*/_react.default.createElement(_pipeline_form_error.PipelineFormError, {
    error: saveError
  }), /*#__PURE__*/_react.default.createElement(_pipeline_form_fields.PipelineFormFields, {
    onLoadJson: ({
      processors,
      on_failure: onFailure
    }) => {
      setProcessorsState({
        processors,
        onFailure
      });
    },
    onEditorFlyoutOpen: onEditorFlyoutOpen,
    processors: processorsState.processors,
    onFailure: processorsState.onFailure,
    onProcessorsUpdate: onProcessorsChangeHandler,
    hasVersion: Boolean(defaultValue.version),
    hasMeta: Boolean(defaultValue._meta && Object.keys(defaultValue._meta).length),
    isEditing: isEditing,
    canEditName: canEditName
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "success",
    iconType: "check",
    onClick: form.submit,
    "data-test-subj": "submitButton",
    disabled: form.isSubmitted && form.isValid === false,
    isLoading: isSaving
  }, saveButtonLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    onClick: onCancel
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.form.cancelButtonLabel",
    defaultMessage: "Cancel"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "showRequestLink",
    onClick: () => setIsRequestVisible(prevIsRequestVisible => !prevIsRequestVisible)
  }, isRequestVisible ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.form.hideRequestButtonLabel",
    defaultMessage: "Hide request"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.form.showRequestButtonLabel",
    defaultMessage: "Show request"
  })))), isRequestVisible ? /*#__PURE__*/_react.default.createElement(_pipeline_request_flyout.PipelineRequestFlyout, {
    readProcessors: () => {
      var _processorStateRef$cu;
      return ((_processorStateRef$cu = processorStateRef.current) === null || _processorStateRef$cu === void 0 ? void 0 : _processorStateRef$cu.getData()) || {
        processors: [],
        on_failure: []
      };
    },
    closeFlyout: () => setIsRequestVisible(prevIsRequestVisible => !prevIsRequestVisible)
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.PipelineForm = PipelineForm;