"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsExplorerViewsService = void 0;
var _metrics_explorer_views_client = require("./metrics_explorer_views_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MetricsExplorerViewsService {
  constructor(logger) {
    this.logger = logger;
  }
  setup() {}
  start({
    infraSources,
    savedObjects
  }) {
    const {
      logger
    } = this;
    return {
      getClient(savedObjectsClient) {
        return new _metrics_explorer_views_client.MetricsExplorerViewsClient(logger, savedObjectsClient, infraSources);
      },
      getScopedClient(request) {
        const savedObjectsClient = savedObjects.getScopedClient(request);
        return this.getClient(savedObjectsClient);
      }
    };
  }
}
exports.MetricsExplorerViewsService = MetricsExplorerViewsService;