"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initServicesRoute = void 0;
var _host_details = require("../../../common/http_api/host_details");
var _get_services = require("../../lib/host_details/get_services");
var _utils = require("./lib/utils");
var _create_search_client = require("../../lib/create_search_client");
var _route_validation = require("../../utils/route_validation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initServicesRoute = libs => {
  const {
    framework
  } = libs;
  framework.registerRoute({
    method: 'get',
    path: '/api/infra/services',
    validate: {
      query: (q, res) => {
        const [invalidResponse, parsedFilters] = (0, _utils.validateStringAssetFilters)(q, res);
        if (invalidResponse) {
          return invalidResponse;
        }
        q.validatedFilters = parsedFilters;
        return (0, _route_validation.buildRouteValidationWithExcess)(_host_details.GetServicesRequestQueryRT)(q, res);
      }
    }
  }, async (requestContext, request, response) => {
    const [{
      savedObjects
    }] = await libs.getStartServices();
    const {
      from,
      to,
      size = 10,
      validatedFilters
    } = request.query;
    const client = (0, _create_search_client.createSearchClient)(requestContext, framework, request);
    const soClient = savedObjects.getScopedClient(request);
    const apmIndices = await libs.getApmIndices(soClient);
    const services = await (0, _get_services.getServices)(client, apmIndices, {
      from,
      to,
      size,
      filters: validatedFilters
    });
    return response.ok({
      body: _host_details.ServicesAPIResponseRT.encode(services)
    });
  });
};
exports.initServicesRoute = initServicesRoute;