"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHosts = void 0;
var _get_filtered_hosts = require("./get_filtered_hosts");
var _utils = require("../utils");
var _get_all_hosts = require("./get_all_hosts");
var _get_hosts_alerts_count = require("./get_hosts_alerts_count");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getHosts = async args => {
  const runFilterQuery = (0, _utils.hasFilters)(args.params.query);
  // filter first to prevent filter clauses from impacting the metrics aggregations.
  const hostNamesShortList = runFilterQuery ? await getFilteredHostNames(args) : [];
  if (runFilterQuery && hostNamesShortList.length === 0) {
    return {
      type: 'host',
      nodes: []
    };
  }
  const {
    range: {
      from,
      to
    },
    limit
  } = args.params;
  const [hostMetrics, alertsCountResponse] = await Promise.all([(0, _get_all_hosts.getAllHosts)(args, hostNamesShortList), (0, _get_hosts_alerts_count.getHostsAlertsCount)({
    alertsClient: args.alertsClient,
    hostNamesShortList,
    from,
    to,
    maxNumHosts: limit
  })]);
  const alertsByHostName = alertsCountResponse.reduce((acc, {
    name,
    alertsCount
  }) => {
    acc[name] = {
      alertsCount
    };
    return acc;
  }, {});
  const hosts = hostMetrics.map(({
    name,
    metrics,
    metadata
  }) => {
    var _alertsByHostName$nam;
    const {
      alertsCount
    } = (_alertsByHostName$nam = alertsByHostName[name]) !== null && _alertsByHostName$nam !== void 0 ? _alertsByHostName$nam : {};
    return {
      name,
      metrics,
      metadata,
      alertsCount
    };
  });
  return {
    type: args.params.type,
    nodes: hosts
  };
};
exports.getHosts = getHosts;
const getFilteredHostNames = async args => {
  var _filteredHosts$aggreg, _nodes$buckets$map;
  const filteredHosts = await (0, _get_filtered_hosts.getFilteredHosts)(args);
  const {
    nodes
  } = (_filteredHosts$aggreg = filteredHosts.aggregations) !== null && _filteredHosts$aggreg !== void 0 ? _filteredHosts$aggreg : {};
  return (_nodes$buckets$map = nodes === null || nodes === void 0 ? void 0 : nodes.buckets.map(p => p.key)) !== null && _nodes$buckets$map !== void 0 ? _nodes$buckets$map : [];
};