"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAllHosts = void 0;
var _constants = require("../constants");
var _query = require("../helpers/query");
var _types = require("../../../../lib/metrics/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAllHosts = async ({
  infraMetricsClient,
  params
}, hostNamesShortList = []) => {
  var _response$aggregation, _response$aggregation2;
  const query = createQuery(params, hostNamesShortList);
  const response = await infraMetricsClient.search(query);
  const result = ((_response$aggregation = (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.nodes.buckets) !== null && _response$aggregation !== void 0 ? _response$aggregation : []).sort((a, b) => {
    var _getMetricValue, _getMetricValue2;
    const aValue = (_getMetricValue = getMetricValue(a === null || a === void 0 ? void 0 : a.cpu)) !== null && _getMetricValue !== void 0 ? _getMetricValue : 0;
    const bValue = (_getMetricValue2 = getMetricValue(b === null || b === void 0 ? void 0 : b.cpu)) !== null && _getMetricValue2 !== void 0 ? _getMetricValue2 : 0;
    return bValue - aValue;
  }).map(bucket => {
    var _bucket$metadata$top;
    const metadata = ((_bucket$metadata$top = bucket === null || bucket === void 0 ? void 0 : bucket.metadata.top) !== null && _bucket$metadata$top !== void 0 ? _bucket$metadata$top : []).flatMap(top => Object.entries(top.metrics)).map(([key, value]) => ({
      name: key,
      value: typeof value === 'string' && value.trim().length === 0 ? null : value
    }));
    const metrics = params.metrics.map(metric => {
      var _getMetricValue3;
      return {
        name: metric.type,
        value: metric.type in bucket ? (_getMetricValue3 = getMetricValue(bucket[metric.type])) !== null && _getMetricValue3 !== void 0 ? _getMetricValue3 : 0 : null
      };
    });
    return {
      name: bucket === null || bucket === void 0 ? void 0 : bucket.key,
      metadata,
      metrics
    };
  });
  return result;
};
exports.getAllHosts = getAllHosts;
const createQuery = (params, hostNamesShortList) => {
  var _params$limit;
  const metricAggregations = (0, _query.getInventoryModelAggregations)(params.type, params.metrics.map(p => p.type));
  return {
    allow_no_indices: true,
    ignore_unavailable: true,
    body: {
      size: 0,
      track_total_hits: false,
      query: {
        bool: {
          filter: (0, _query.createFilters)({
            params,
            hostNamesShortList
          })
        }
      },
      aggs: {
        nodes: {
          terms: {
            field: _constants.BUCKET_KEY,
            size: (_params$limit = params.limit) !== null && _params$limit !== void 0 ? _params$limit : _constants.MAX_SIZE,
            order: {
              _key: 'asc'
            }
          },
          aggs: {
            ...metricAggregations,
            [_constants.METADATA_AGGREGATION_NAME]: {
              top_metrics: {
                metrics: [{
                  field: 'host.os.name'
                }, {
                  field: 'cloud.provider'
                }, {
                  field: 'host.ip'
                }],
                size: 1,
                sort: {
                  '@timestamp': 'desc'
                }
              }
            }
          }
        }
      }
    }
  };
};
const getMetricValue = valueObject => {
  if (_types.BasicMetricValueRT.is(valueObject)) {
    return valueObject.value;
  }
  return valueObject;
};