"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerInventoryThresholdRuleType = registerInventoryThresholdRuleType;
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
var _server = require("@kbn/core/server");
var _common = require("@kbn/observability-plugin/common");
var _common2 = require("@kbn/metrics-data-access-plugin/common");
var _metrics = require("../../../../common/alerting/metrics");
var _snapshot_api = require("../../../../common/http_api/snapshot_api");
var _messages = require("../common/messages");
var _utils = require("../common/utils");
var _inventory_metric_threshold_executor = require("./inventory_metric_threshold_executor");
var _register_rule_types = require("../register_rule_types");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const condition = _configSchema.schema.object({
  threshold: _configSchema.schema.arrayOf(_configSchema.schema.number()),
  comparator: (0, _utils.oneOfLiterals)(Object.values(_metrics.Comparator)),
  timeUnit: _configSchema.schema.string(),
  timeSize: _configSchema.schema.number(),
  metric: (0, _utils.oneOfLiterals)(Object.keys(_common2.SnapshotMetricTypeKeys)),
  warningThreshold: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number())),
  warningComparator: _configSchema.schema.maybe((0, _utils.oneOfLiterals)(Object.values(_metrics.Comparator))),
  customMetric: _configSchema.schema.maybe(_configSchema.schema.object({
    type: _configSchema.schema.literal('custom'),
    id: _configSchema.schema.string(),
    field: _configSchema.schema.string(),
    aggregation: (0, _utils.oneOfLiterals)(_snapshot_api.SNAPSHOT_CUSTOM_AGGREGATIONS),
    label: _configSchema.schema.maybe(_configSchema.schema.string())
  }))
});
const groupActionVariableDescription = _i18n.i18n.translate('xpack.infra.inventory.alerting.groupActionVariableDescription', {
  defaultMessage: 'Name of the group reporting data'
});
async function registerInventoryThresholdRuleType(alertingPlugin, libs, {
  featureFlags
}) {
  if (!featureFlags.inventoryThresholdAlertRuleEnabled) {
    return;
  }
  const paramsSchema = _configSchema.schema.object({
    criteria: _configSchema.schema.arrayOf(condition),
    nodeType: _configSchema.schema.string(),
    filterQuery: _configSchema.schema.maybe(_configSchema.schema.string({
      validate: _utils.validateIsStringElasticsearchJSONFilter
    })),
    sourceId: _configSchema.schema.string(),
    alertOnNoData: _configSchema.schema.maybe(_configSchema.schema.boolean())
  }, {
    unknowns: 'allow'
  });
  alertingPlugin.registerType({
    id: _metrics.METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID,
    name: _i18n.i18n.translate('xpack.infra.metrics.inventory.alertName', {
      defaultMessage: 'Inventory'
    }),
    validate: {
      params: paramsSchema
    },
    schemas: {
      params: {
        type: 'config-schema',
        schema: paramsSchema
      }
    },
    defaultActionGroupId: _inventory_metric_threshold_executor.FIRED_ACTIONS_ID,
    doesSetRecoveryContext: true,
    actionGroups: [_inventory_metric_threshold_executor.FIRED_ACTIONS, _inventory_metric_threshold_executor.WARNING_ACTIONS],
    category: _server.DEFAULT_APP_CATEGORIES.observability.id,
    producer: 'infrastructure',
    minimumLicenseRequired: 'basic',
    isExportable: true,
    executor: (0, _inventory_metric_threshold_executor.createInventoryMetricThresholdExecutor)(libs),
    actionVariables: {
      context: [{
        name: 'group',
        description: groupActionVariableDescription
      }, {
        name: 'alertState',
        description: _messages.alertStateActionVariableDescription
      }, {
        name: 'alertDetailsUrl',
        description: _messages.alertDetailUrlActionVariableDescription,
        usesPublicBaseUrl: true
      }, {
        name: 'reason',
        description: _messages.reasonActionVariableDescription
      }, {
        name: 'timestamp',
        description: _messages.timestampActionVariableDescription
      }, {
        name: 'value',
        description: _messages.valueActionVariableDescription
      }, {
        name: 'metric',
        description: _messages.metricActionVariableDescription
      }, {
        name: 'threshold',
        description: _messages.thresholdActionVariableDescription
      }, {
        name: 'viewInAppUrl',
        description: _messages.viewInAppUrlActionVariableDescription,
        usesPublicBaseUrl: true
      }, {
        name: 'cloud',
        description: _messages.cloudActionVariableDescription
      }, {
        name: 'host',
        description: _messages.hostActionVariableDescription
      }, {
        name: 'container',
        description: _messages.containerActionVariableDescription
      }, {
        name: 'orchestrator',
        description: _messages.orchestratorActionVariableDescription
      }, {
        name: 'labels',
        description: _messages.labelsActionVariableDescription
      }, {
        name: 'tags',
        description: _messages.tagsActionVariableDescription
      }, {
        name: 'originalAlertState',
        description: _messages.originalAlertStateActionVariableDescription
      }, {
        name: 'originalAlertStateWasALERT',
        description: _messages.originalAlertStateWasActionVariableDescription
      }, {
        name: 'originalAlertStateWasWARNING',
        description: _messages.originalAlertStateWasActionVariableDescription
      }]
    },
    alerts: _register_rule_types.MetricsRulesTypeAlertDefinition,
    fieldsForAAD: _constants.O11Y_AAD_FIELDS,
    getViewInAppRelativeUrl: ({
      rule
    }) => _common.observabilityPaths.ruleDetails(rule.id)
  });
}