"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimelineChartTheme = useTimelineChartTheme;
var _eui = require("@elastic/eui");
var _use_kibana = require("../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useTimelineChartTheme() {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    services: {
      charts
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const baseTheme = charts.theme.useChartsBaseTheme();
  return {
    baseTheme,
    theme: {
      background: {
        color: 'transparent'
      },
      crosshair: {
        band: {
          fill: euiTheme.colors.lightShade
        }
      },
      axes: {
        gridLine: {
          horizontal: {
            visible: false
          },
          vertical: {
            dash: undefined
          }
        }
      }
    }
  };
}