"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsPageTemplate = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _empty_states = require("../../components/empty_states");
var _metrics_source = require("../../containers/metrics_source");
var _use_kibana = require("../../hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricsPageTemplate = ({
  hasData = true,
  'data-test-subj': _dataTestSubj,
  ...pageTemplateProps
}) => {
  const {
    services: {
      observabilityAIAssistant,
      observabilityShared: {
        navigation: {
          PageTemplate
        }
      },
      docLinks
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    source
  } = (0, _metrics_source.useSourceContext)();
  const noDataConfig = hasData ? undefined : {
    solution: _i18n.i18n.translate('xpack.infra.metrics.noDataConfig.solutionName', {
      defaultMessage: 'Observability'
    }),
    action: {
      beats: {
        title: _empty_states.noMetricIndicesPromptPrimaryActionTitle,
        description: _empty_states.noMetricIndicesPromptDescription
      }
    },
    docsLink: docLinks.links.observability.guide
  };
  const {
    setScreenContext
  } = (observabilityAIAssistant === null || observabilityAIAssistant === void 0 ? void 0 : observabilityAIAssistant.service) || {};
  (0, _react.useEffect)(() => {
    return setScreenContext === null || setScreenContext === void 0 ? void 0 : setScreenContext({
      data: [{
        name: 'Metrics configuration',
        value: source,
        description: 'The configuration of the Metrics app'
      }],
      starterPrompts: [...(!hasData ? [{
        title: _i18n.i18n.translate('xpack.infra.metrics.aiAssistant.starterPrompts.explainNoData.title', {
          defaultMessage: 'Explain'
        }),
        prompt: _i18n.i18n.translate('xpack.infra.metrics.aiAssistant.starterPrompts.explainNoData.prompt', {
          defaultMessage: "Why don't I see any data?"
        }),
        icon: 'sparkles'
      }] : [])]
    });
  }, [hasData, setScreenContext, source]);
  return /*#__PURE__*/_react.default.createElement(PageTemplate, (0, _extends2.default)({
    "data-test-subj": hasData ? _dataTestSubj : 'noDataPage',
    noDataConfig: noDataConfig
  }, pageTemplateProps));
};
exports.MetricsPageTemplate = MetricsPageTemplate;