"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsExplorerMetrics = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _color_palette = require("../../../../../common/color_palette");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricsExplorerMetrics = ({
  options,
  onChange,
  fields,
  autoFocus = false
}) => {
  const colors = Object.keys(_color_palette.Color);
  const [shouldFocus, setShouldFocus] = (0, _react.useState)(autoFocus);

  // the EuiCombobox forwards the ref to an input element
  const autoFocusInputElement = (0, _react.useCallback)(inputElement => {
    if (inputElement && shouldFocus) {
      inputElement.focus();
      setShouldFocus(false);
    }
  }, [shouldFocus]);
  const handleChange = (0, _react.useCallback)(selectedOptions => {
    onChange(selectedOptions.map((opt, index) => ({
      aggregation: options.aggregation,
      field: opt.value,
      color: colors[index]
    })));
  }, [onChange, options.aggregation, colors]);
  const comboOptions = fields.map(field => ({
    label: field.name,
    value: field.name
  }));
  const selectedOptions = options.metrics.filter(m => m.aggregation !== 'count').map(metric => ({
    label: metric.field || '',
    value: metric.field || '',
    color: (0, _color_palette.colorTransformer)(metric.color || _color_palette.Color.color0)
  }));
  const placeholderText = _i18n.i18n.translate('xpack.infra.metricsExplorer.metricComboBoxPlaceholder', {
    defaultMessage: 'choose a metric to plot'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "metricsExplorer-metrics",
    "aria-label": placeholderText,
    isDisabled: options.aggregation === 'count',
    placeholder: placeholderText,
    fullWidth: true,
    options: comboOptions,
    selectedOptions: selectedOptions,
    onChange: handleChange,
    isClearable: true,
    inputRef: autoFocusInputElement
  });
};
exports.MetricsExplorerMetrics = MetricsExplorerMetrics;