"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricDetailPage = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _use_metrics_breadcrumbs = require("../../../hooks/use_metrics_breadcrumbs");
var _use_parent_breadcrumb_resolver = require("../../../hooks/use_parent_breadcrumb_resolver");
var _use_metadata = require("../../../components/asset_details/hooks/use_metadata");
var _metrics_source = require("../../../containers/metrics_source");
var _loading = require("../../../components/loading");
var _node_details_page = require("./components/node_details_page");
var _use_metrics_time = require("./hooks/use_metrics_time");
var _page_template = require("../page_template");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricDetailPage = () => {
  const {
    params: {
      type: nodeType,
      node: nodeId
    }
  } = (0, _reactRouterDom.useRouteMatch)();
  const inventoryModel = (0, _common.findInventoryModel)(nodeType);
  const {
    sourceId,
    metricIndicesExist
  } = (0, _metrics_source.useSourceContext)();
  const parentBreadcrumbResolver = (0, _use_parent_breadcrumb_resolver.useParentBreadcrumbResolver)();
  const {
    timeRange,
    parsedTimeRange,
    setTimeRange,
    refreshInterval,
    setRefreshInterval,
    isAutoReloading,
    setAutoReload,
    triggerRefresh
  } = (0, _use_metrics_time.useMetricsTimeContext)();
  const {
    name,
    filteredRequiredMetrics,
    loading: metadataLoading,
    cloudId,
    metadata
  } = (0, _use_metadata.useMetadata)({
    assetId: nodeId,
    assetType: nodeType,
    requiredMetrics: inventoryModel.requiredMetrics,
    sourceId,
    timeRange: parsedTimeRange
  });
  const breadcrumbOptions = parentBreadcrumbResolver.getBreadcrumbOptions(nodeType);
  (0, _use_metrics_breadcrumbs.useMetricsBreadcrumbs)([{
    ...breadcrumbOptions.link,
    text: breadcrumbOptions.text
  }, {
    text: name
  }], {
    deeperContextServerless: true
  });
  const [sideNav, setSideNav] = (0, _react.useState)([]);
  const addNavItem = _react.default.useCallback(item => {
    if (!sideNav.some(n => n.id === item.id)) {
      setSideNav([item, ...sideNav]);
    }
  }, [sideNav]);
  if (metadataLoading && !filteredRequiredMetrics.length) {
    return /*#__PURE__*/_react.default.createElement(_page_template.MetricsPageTemplate, {
      hasData: metricIndicesExist
    }, /*#__PURE__*/_react.default.createElement(_loading.InfraLoadingPanel, {
      height: "100vh",
      width: "100%",
      text: _i18n.i18n.translate('xpack.infra.metrics.loadingNodeDataText', {
        defaultMessage: 'Loading data'
      })
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, metadata ? /*#__PURE__*/_react.default.createElement(_node_details_page.NodeDetailsPage, {
    name: name,
    requiredMetrics: filteredRequiredMetrics,
    sourceId: sourceId,
    timeRange: timeRange,
    nodeType: nodeType,
    nodeId: nodeId,
    cloudId: cloudId,
    metadataLoading: metadataLoading,
    isAutoReloading: isAutoReloading,
    refreshInterval: refreshInterval,
    sideNav: sideNav,
    metadata: metadata,
    addNavItem: addNavItem,
    setRefreshInterval: setRefreshInterval,
    setAutoReload: setAutoReload,
    triggerRefresh: triggerRefresh,
    setTimeRange: setTimeRange
  }) : null);
};
exports.MetricDetailPage = MetricDetailPage;