"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomMetricForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/kibana-react-plugin/common");
var _snapshot_api = require("../../../../../../../common/http_api/snapshot_api");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AGGREGATION_LABELS = {
  ['avg']: _i18n.i18n.translate('xpack.infra.waffle.customMetrics.aggregationLables.avg', {
    defaultMessage: 'Average'
  }),
  ['max']: _i18n.i18n.translate('xpack.infra.waffle.customMetrics.aggregationLables.max', {
    defaultMessage: 'Max'
  }),
  ['min']: _i18n.i18n.translate('xpack.infra.waffle.customMetrics.aggregationLables.min', {
    defaultMessage: 'Min'
  }),
  ['rate']: _i18n.i18n.translate('xpack.infra.waffle.customMetrics.aggregationLables.rate', {
    defaultMessage: 'Rate'
  })
};
const CustomMetricForm = exports.CustomMetricForm = (0, _common.withTheme)(({
  theme,
  onCancel,
  fields,
  onChange,
  metric
}) => {
  const [label, setLabel] = (0, _react.useState)(metric ? metric.label : void 0);
  const [aggregation, setAggregation] = (0, _react.useState)(metric ? metric.aggregation : 'avg');
  const [field, setField] = (0, _react.useState)(metric ? metric.field : void 0);
  const handleSubmit = (0, _react.useCallback)(() => {
    if (metric && aggregation && field) {
      onChange({
        ...metric,
        label,
        aggregation,
        field
      });
    } else if (aggregation && field) {
      const newMetric = {
        type: 'custom',
        id: (0, _uuid.v4)(),
        label,
        aggregation,
        field
      };
      onChange(newMetric);
    }
  }, [metric, aggregation, field, onChange, label]);
  const handleLabelChange = (0, _react.useCallback)(e => {
    setLabel(e.target.value);
  }, [setLabel]);
  const handleFieldChange = (0, _react.useCallback)(selectedOptions => {
    setField(selectedOptions[0].label);
  }, [setField]);
  const handleAggregationChange = (0, _react.useCallback)(e => {
    const value = e.target.value;
    const aggValue = _snapshot_api.SnapshotCustomAggregationRT.is(value) ? value : 'avg';
    setAggregation(aggValue);
  }, [setAggregation]);
  const fieldOptions = fields.filter(f => f.aggregatable && f.type === 'number' && !(field && field === f.name)).map(f => ({
    label: f.name
  }));
  const aggregationOptions = _snapshot_api.SNAPSHOT_CUSTOM_AGGREGATIONS.map(k => ({
    text: AGGREGATION_LABELS[k],
    value: k
  }));
  const isSubmitDisabled = !field || !aggregation;
  const title = metric ? _i18n.i18n.translate('xpack.infra.waffle.customMetricPanelLabel.edit', {
    defaultMessage: 'Edit custom metric'
  }) : _i18n.i18n.translate('xpack.infra.waffle.customMetricPanelLabel.add', {
    defaultMessage: 'Add custom metric'
  });
  const titleAriaLabel = metric ? _i18n.i18n.translate('xpack.infra.waffle.customMetricPanelLabel.editAriaLabel', {
    defaultMessage: 'Back to custom metrics edit mode'
  }) : _i18n.i18n.translate('xpack.infra.waffle.customMetricPanelLabel.addAriaLabel', {
    defaultMessage: 'Back to metric picker'
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 685
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "infraCustomMetricFormButton",
    iconType: "arrowLeft",
    onClick: onCancel,
    color: "text",
    size: "xs",
    flush: "left",
    style: {
      fontWeight: 700,
      textTransform: 'uppercase'
    },
    "aria-label": titleAriaLabel
  }, title)), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      padding: theme === null || theme === void 0 ? void 0 : theme.eui.euiSizeM,
      borderBottom: `${theme === null || theme === void 0 ? void 0 : theme.eui.euiBorderWidthThin} solid ${theme === null || theme === void 0 ? void 0 : theme.eui.euiBorderColor}`
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.infra.waffle.customMetrics.metricLabel', {
      defaultMessage: 'Metric'
    }),
    display: "rowCompressed",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "infraCustomMetricFormSelect",
    onChange: handleAggregationChange,
    value: aggregation,
    options: aggregationOptions,
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("span", null, "of"))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.infra.waffle.customMetrics.fieldPlaceholder', {
      defaultMessage: 'Select a field'
    }),
    singleSelection: {
      asPlainText: true
    },
    selectedOptions: field ? [{
      label: field
    }] : [],
    options: fieldOptions,
    onChange: handleFieldChange,
    isClearable: false
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.infra.waffle.customMetrics.labelLabel', {
      defaultMessage: 'Label (optional)'
    }),
    display: "rowCompressed",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "infraCustomMetricFormFieldText",
    name: "label",
    placeholder: _i18n.i18n.translate('xpack.infra.waffle.customMetrics.labelPlaceholder', {
      defaultMessage: 'Choose a name to appear in the "Metric" dropdown'
    }),
    value: label,
    fullWidth: true,
    onChange: handleLabelChange
  }))), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      padding: theme === null || theme === void 0 ? void 0 : theme.eui.euiSizeM,
      textAlign: 'right'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "infraCustomMetricFormCancelButton",
    onClick: onCancel,
    size: "s",
    style: {
      paddingRight: theme === null || theme === void 0 ? void 0 : theme.eui.euiSizeXL
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.waffle.customMetrics.cancelLabel",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraCustomMetricFormSaveButton",
    type: "submit",
    size: "s",
    fill: true,
    onClick: handleSubmit,
    disabled: isSubmitDisabled
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.waffle.customMetrics.submitLabel",
    defaultMessage: "Save"
  })))));
});