"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMetricsDataViewContext = exports.useMetricsDataView = exports.MetricsDataViewProvider = exports.MetricsDataView = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _use_data_view = require("../../../../hooks/use_data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMetricsDataView = ({
  metricAlias
}) => {
  const {
    dataView,
    loading,
    retry,
    error
  } = (0, _use_data_view.useDataView)({
    index: metricAlias
  });
  return {
    metricAlias,
    dataView,
    loading,
    retry,
    error
  };
};
exports.useMetricsDataView = useMetricsDataView;
const MetricsDataView = exports.MetricsDataView = (0, _constate.default)(useMetricsDataView);
const [MetricsDataViewProvider, useMetricsDataViewContext] = MetricsDataView;
exports.useMetricsDataViewContext = useMetricsDataViewContext;
exports.MetricsDataViewProvider = MetricsDataViewProvider;