"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsGrid = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _lens = require("../../../../../../components/lens");
var _chart = require("./chart");
var _popover = require("../../common/popover");
var _use_metrics_data_view = require("../../../hooks/use_metrics_data_view");
var _use_metrics_charts = require("../../../hooks/use_metrics_charts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricsGrid = () => {
  const {
    dataView
  } = (0, _use_metrics_data_view.useMetricsDataViewContext)();
  const charts = (0, _use_metrics_charts.useMetricsCharts)({
    dataViewId: dataView === null || dataView === void 0 ? void 0 : dataView.id
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, _i18n.i18n.translate('xpack.infra.metricsGrid.learnMoreAboutMetricsTextLabel', {
    defaultMessage: 'Learn more about metrics'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_popover.Popover, null, /*#__PURE__*/_react.default.createElement(_lens.HostMetricsExplanationContent, null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "s",
    "data-test-subj": "hostsView-metricChart"
  }, charts.map((chartProp, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_chart.Chart, chartProp)))));
};
exports.MetricsGrid = MetricsGrid;