"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KpiCharts = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _asset_details = require("../../../../../components/asset_details");
var _build = require("../../../../../utils/filters/build");
var _use_unified_search = require("../../hooks/use_unified_search");
var _use_hosts_view = require("../../hooks/use_hosts_view");
var _use_host_count = require("../../hooks/use_host_count");
var _use_after_loaded_state = require("../../hooks/use_after_loaded_state");
var _use_metrics_data_view = require("../../hooks/use_metrics_data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KpiCharts = () => {
  var _searchCriteria$panel;
  const {
    searchCriteria
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const {
    hostNodes,
    loading: hostsLoading,
    searchSessionId
  } = (0, _use_hosts_view.useHostsViewContext)();
  const {
    isRequestRunning: hostCountLoading,
    data: hostCountData
  } = (0, _use_host_count.useHostCountContext)();
  const {
    dataView
  } = (0, _use_metrics_data_view.useMetricsDataViewContext)();
  const shouldUseSearchCriteria = hostNodes.length === 0;
  const loading = hostsLoading || hostCountLoading;
  const filters = shouldUseSearchCriteria ? [...searchCriteria.filters, ...((_searchCriteria$panel = searchCriteria.panelFilters) !== null && _searchCriteria$panel !== void 0 ? _searchCriteria$panel : [])] : [(0, _build.buildCombinedHostsFilter)({
    field: 'host.name',
    values: hostNodes.map(p => p.name),
    dataView
  })];
  const getSubtitle = formulaValue => {
    var _hostCountData$count$2;
    if (formulaValue.startsWith('max')) {
      var _hostCountData$count$;
      return searchCriteria.limit < ((_hostCountData$count$ = hostCountData === null || hostCountData === void 0 ? void 0 : hostCountData.count.value) !== null && _hostCountData$count$ !== void 0 ? _hostCountData$count$ : 0) ? _i18n.i18n.translate('xpack.infra.hostsViewPage.kpi.subtitle.max.limit', {
        defaultMessage: 'Max (of {limit} hosts)',
        values: {
          limit: searchCriteria.limit
        }
      }) : _i18n.i18n.translate('xpack.infra.hostsViewPage.kpi.subtitle.max', {
        defaultMessage: 'Max'
      });
    }
    return searchCriteria.limit < ((_hostCountData$count$2 = hostCountData === null || hostCountData === void 0 ? void 0 : hostCountData.count.value) !== null && _hostCountData$count$2 !== void 0 ? _hostCountData$count$2 : 0) ? _i18n.i18n.translate('xpack.infra.hostsViewPage.kpi.subtitle.average.limit', {
      defaultMessage: 'Average (of {limit} hosts)',
      values: {
        limit: searchCriteria.limit
      }
    }) : _i18n.i18n.translate('xpack.infra.hostsViewPage.kpi.subtitle.average', {
      defaultMessage: 'Average'
    });
  };

  // prevents requestTs and searchCriteria state from reloading the chart
  // we want it to reload only once the table has finished loading.
  // attributes passed to useAfterLoadedState don't need to be memoized
  const {
    afterLoadedState
  } = (0, _use_after_loaded_state.useAfterLoadedState)(loading, {
    dateRange: searchCriteria.dateRange,
    query: shouldUseSearchCriteria ? searchCriteria.query : undefined,
    filters,
    searchSessionId,
    getSubtitle
  });
  return /*#__PURE__*/_react.default.createElement(_asset_details.HostKpiCharts, {
    dataView: dataView,
    dateRange: afterLoadedState.dateRange,
    filters: afterLoadedState.filters,
    query: afterLoadedState.query,
    searchSessionId: afterLoadedState.searchSessionId,
    options: {
      getSubtitle: afterLoadedState.getSubtitle
    },
    loading: loading
  });
};
exports.KpiCharts = KpiCharts;