"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNodeDetailsRedirect = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _use_kibana = require("../../hooks/use_kibana");
var _redirect_to_node_detail = require("./redirect_to_node_detail");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useNodeDetailsRedirect = () => {
  const location = (0, _reactRouterDom.useLocation)();
  const {
    services: {
      application: {
        currentAppId$
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const appId = (0, _useObservable.default)(currentAppId$);
  const getNodeDetailUrl = (0, _react.useCallback)(({
    assetType,
    assetId,
    search
  }) => {
    const {
      from,
      to,
      ...additionalParams
    } = search;
    return {
      app: 'metrics',
      pathname: `link-to/${assetType}-detail/${assetId}`,
      search: {
        ...(Object.keys(additionalParams).length > 0 ? {
          [_redirect_to_node_detail.REDIRECT_ASSET_DETAILS_KEY]: _rison.default.encodeUnknown(additionalParams)
        } : undefined),
        // retrocompatibility
        ...(from ? {
          [_redirect_to_node_detail.REDIRECT_NODE_DETAILS_FROM_KEY]: `${from}`
        } : undefined),
        ...(to ? {
          [_redirect_to_node_detail.REDIRECT_NODE_DETAILS_TO_KEY]: `${to}`
        } : undefined)
      },
      state: {
        ...(location.key ? {
          originAppId: appId,
          originSearch: location.search,
          originPathname: location.pathname
        } : undefined)
      }
    };
  }, [location.key, location.search, location.pathname, appId]);
  return {
    getNodeDetailUrl
  };
};
exports.useNodeDetailsRedirect = useNodeDetailsRedirect;