"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkToMetricsPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _redirect_to_node_detail = require("./redirect_to_node_detail");
var _redirect_to_host_detail_via_ip = require("./redirect_to_host_detail_via_ip");
var _redirect_to_inventory = require("./redirect_to_inventory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ITEM_TYPES = _common.inventoryModels.map(m => m.id).join('|');
const LinkToMetricsPage = props => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${props.match.url}/:nodeType(${ITEM_TYPES})-detail/:nodeId`,
    component: _redirect_to_node_detail.RedirectToNodeDetail
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${props.match.url}/host-detail-via-ip/:hostIp`,
    component: _redirect_to_host_detail_via_ip.RedirectToHostDetailViaIP
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${props.match.url}/inventory`,
    component: _redirect_to_inventory.RedirectToInventory
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: "/"
  }));
};
exports.LinkToMetricsPage = LinkToMetricsPage;