"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logStreamQueryNotificationEventSelectors = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const logStreamQueryNotificationEventSelectors = exports.logStreamQueryNotificationEventSelectors = {
  validQueryChanged: context => 'parsedQuery' in context ? {
    type: 'VALID_QUERY_CHANGED',
    parsedQuery: context.parsedQuery
  } : undefined,
  invalidQueryChanged: context => 'validationError' in context ? {
    type: 'INVALID_QUERY_CHANGED',
    parsedQuery: context.parsedQuery,
    error: context.validationError
  } : undefined,
  timeChanged: context => {
    return 'timeRange' in context && 'refreshInterval' in context && 'timestamps' in context ? {
      type: 'TIME_CHANGED',
      timeRange: context.timeRange,
      refreshInterval: context.refreshInterval,
      timestamps: context.timestamps
    } : undefined;
  }
};