"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useKibanaIndexPatternTitles = exports.useKibanaIndexPatternService = void 0;
var _react = require("react");
var _use_tracked_promise = require("../utils/use_tracked_promise");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useKibanaIndexPatternService = () => {
  const {
    services: {
      dataViews
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  return dataViews;
};
exports.useKibanaIndexPatternService = useKibanaIndexPatternService;
const useKibanaIndexPatternTitles = () => {
  const indexPatterns = useKibanaIndexPatternService();
  const [indexPatternTitles, setIndexPatternTitles] = (0, _react.useState)([]);
  const [indexPatternTitlesRequest, fetchIndexPatternTitles] = (0, _use_tracked_promise.useTrackedPromise)({
    createPromise: () => indexPatterns.getIdsWithTitle(true),
    onResolve: setIndexPatternTitles
  }, [indexPatterns]);
  return {
    fetchIndexPatternTitles,
    indexPatternTitles,
    latestIndexPatternTitlesRequest: indexPatternTitlesRequest
  };
};
exports.useKibanaIndexPatternTitles = useKibanaIndexPatternTitles;