"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServicesSectionTitle = exports.MetricsSectionTitle = exports.AlertsSectionTitle = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _lens = require("../../../lens");
var _section_title = require("../../components/section_title");
var _alerts_tooltip_content = require("../../components/alerts_tooltip_content");
var _services_tooltip_content = require("../../components/services_tooltip_content");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricsSectionTitle = () => {
  return /*#__PURE__*/_react.default.createElement(_section_title.TitleWithTooltip, {
    title: _i18n.i18n.translate('xpack.infra.assetDetails.overview.metricsSectionTitle', {
      defaultMessage: 'Metrics'
    }),
    "data-test-subj": "infraAssetDetailsMetricsTitle",
    tooltipTestSubj: "infraAssetDetailsMetricsPopoverButton",
    tooltipContent: /*#__PURE__*/_react.default.createElement(_lens.HostMetricsExplanationContent, null)
  });
};
exports.MetricsSectionTitle = MetricsSectionTitle;
const AlertsSectionTitle = () => {
  return /*#__PURE__*/_react.default.createElement(_section_title.TitleWithTooltip, {
    title: _i18n.i18n.translate('xpack.infra.assetDetails.overview.alertsSectionTitle', {
      defaultMessage: 'Alerts'
    }),
    "data-test-subj": "infraAssetDetailsAlertsTitle",
    tooltipTestSubj: "infraAssetDetailsAlertsPopoverButton",
    tooltipContent: /*#__PURE__*/_react.default.createElement(_alerts_tooltip_content.AlertsTooltipContent, null)
  });
};
exports.AlertsSectionTitle = AlertsSectionTitle;
const ServicesSectionTitle = () => /*#__PURE__*/_react.default.createElement(_section_title.TitleWithTooltip, {
  title: _i18n.i18n.translate('xpack.infra.assetDetails.overview.servicesSectionTitle', {
    defaultMessage: 'Services'
  }),
  "data-test-subj": "infraAssetDetailsServicesTitle",
  tooltipTestSubj: "infraAssetDetailsServicesPopoverButton",
  tooltipContent: /*#__PURE__*/_react.default.createElement(_services_tooltip_content.ServicesTooltipContent, null)
});
exports.ServicesSectionTitle = ServicesSectionTitle;