"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _host_metrics = require("./host_metrics");
var _section = require("../../../components/section");
var _section_titles = require("../section_titles");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricsContent = ({
  assetType,
  ...props
}) => {
  const content = (0, _react.useMemo)(() => {
    switch (assetType) {
      case 'host':
        return /*#__PURE__*/_react.default.createElement(_host_metrics.HostMetrics, props);
      default:
        return null;
    }
  }, [assetType, props]);
  return /*#__PURE__*/_react.default.createElement(_section.Section, {
    title: /*#__PURE__*/_react.default.createElement(_section_titles.MetricsSectionTitle, null),
    "data-test-subj": "infraAssetDetailsMetricsCollapsible",
    id: "metrics",
    collapsible: true
  }, content);
};
exports.MetricsContent = MetricsContent;