"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetadataSummaryListCompact = exports.MetadataSummaryList = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _translations = require("../../../translations");
var _use_tab_switcher = require("../../../hooks/use_tab_switcher");
var _types = require("../../../types");
var _expandable_content = require("../../../components/expandable_content");
var _metadata_header = require("./metadata_header");
var _metadata_explanation = require("../../../components/metadata_explanation");
var _section_title = require("../../../components/section_title");
var _section = require("../../../components/section");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const extendedMetadata = metadataInfo => {
  var _metadataInfo$cloud, _metadataInfo$host, _metadataInfo$host$os;
  return [{
    field: 'cloudProvider',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$cloud = metadataInfo.cloud) === null || _metadataInfo$cloud === void 0 ? void 0 : _metadataInfo$cloud.provider,
    tooltipFieldLabel: 'cloud.provider',
    tooltipLink: 'https://www.elastic.co/guide/en/ecs/current/ecs-cloud.html#field-cloud-provider'
  }, {
    field: 'operatingSystem',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$host = metadataInfo.host) === null || _metadataInfo$host === void 0 ? void 0 : (_metadataInfo$host$os = _metadataInfo$host.os) === null || _metadataInfo$host$os === void 0 ? void 0 : _metadataInfo$host$os.name,
    tooltipFieldLabel: 'host.os.name'
  }];
};
const metadataData = metadataInfo => {
  var _metadataInfo$host2, _metadataInfo$host3, _metadataInfo$host3$o;
  return [{
    field: 'hostIp',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$host2 = metadataInfo.host) === null || _metadataInfo$host2 === void 0 ? void 0 : _metadataInfo$host2.ip,
    tooltipFieldLabel: 'host.ip',
    tooltipLink: 'https://www.elastic.co/guide/en/ecs/current/ecs-host.html#field-host-ip'
  }, {
    field: 'hostOsVersion',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$host3 = metadataInfo.host) === null || _metadataInfo$host3 === void 0 ? void 0 : (_metadataInfo$host3$o = _metadataInfo$host3.os) === null || _metadataInfo$host3$o === void 0 ? void 0 : _metadataInfo$host3$o.version,
    tooltipFieldLabel: 'host.os.version'
  }];
};
const MetadataSummaryListWrapper = ({
  loading: metadataLoading,
  visibleMetadata
}) => {
  const {
    showTab
  } = (0, _use_tab_switcher.useTabSwitcherContext)();
  const onClick = () => {
    showTab(_types.ContentTabIds.METADATA);
  };
  return /*#__PURE__*/_react.default.createElement(_section.Section, {
    title: /*#__PURE__*/_react.default.createElement(_section_title.SectionTitle, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.assetDetails.overview.metadataSectionTitle",
        defaultMessage: "Metadata"
      }),
      "data-test-subj": "infraAssetDetailsMetadataTitle"
    }),
    collapsible: true,
    "data-test-subj": "infraAssetDetailsMetadataCollapsible",
    id: "metadata",
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "infraAssetDetailsMetadataShowAllButton",
      onClick: onClick,
      size: "xs",
      flush: "both",
      iconSide: "right",
      iconType: "sortRight",
      key: "metadata-link"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.assetDetails.metadataSummary.showAllMetadataButton",
      defaultMessage: "Show all"
    }))
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_metadata_explanation.MetadataExplanationMessage, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, visibleMetadata.filter(metadataValue => metadataValue).map(metadataValue => {
    var _metadataValue$value;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: metadataValue.field,
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      "data-test-subj": "infraMetadataSummaryItem",
      compressed: true
    }, /*#__PURE__*/_react.default.createElement(_metadata_header.MetadataHeader, {
      metadataValue: metadataValue
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, metadataLoading && !metadataValue.value ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null) : /*#__PURE__*/_react.default.createElement(_expandable_content.ExpandableContent, {
      values: (_metadataValue$value = metadataValue.value) !== null && _metadataValue$value !== void 0 ? _metadataValue$value : _translations.NOT_AVAILABLE_LABEL
    }))));
  }))));
};
const MetadataSummaryList = ({
  metadata,
  loading
}) => /*#__PURE__*/_react.default.createElement(MetadataSummaryListWrapper, {
  visibleMetadata: [...metadataData(metadata === null || metadata === void 0 ? void 0 : metadata.info), ...extendedMetadata(metadata === null || metadata === void 0 ? void 0 : metadata.info)],
  loading: loading
});
exports.MetadataSummaryList = MetadataSummaryList;
const MetadataSummaryListCompact = ({
  metadata,
  loading
}) => /*#__PURE__*/_react.default.createElement(MetadataSummaryListWrapper, {
  visibleMetadata: metadataData(metadata === null || metadata === void 0 ? void 0 : metadata.info),
  loading: loading
});
exports.MetadataSummaryListCompact = MetadataSummaryListCompact;