"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostMetrics = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_date_picker = require("../../hooks/use_date_picker");
var _use_asset_details_render_props = require("../../hooks/use_asset_details_render_props");
var _use_data_views = require("../../hooks/use_data_views");
var _use_intersecting_state = require("../../hooks/use_intersecting_state");
var _metrics_template = require("./metrics_template");
var _charts = require("../../charts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const METRIC_TYPES = ['cpu', 'memory', 'network', 'disk', 'log'];
const HostMetrics = () => {
  const ref = (0, _react.useRef)(null);
  const {
    dateRange
  } = (0, _use_date_picker.useDatePickerContext)();
  const {
    asset
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const {
    metrics,
    logs
  } = (0, _use_data_views.useDataViewsContext)();
  const state = (0, _use_intersecting_state.useIntersectingState)(ref, {
    dateRange
  });
  return /*#__PURE__*/_react.default.createElement(_metrics_template.MetricsTemplate, {
    ref: ref
  }, METRIC_TYPES.map(metric => /*#__PURE__*/_react.default.createElement(_charts.HostCharts, {
    key: metric,
    assetId: asset.id,
    dataView: metric === 'log' ? logs.dataView : metrics.dataView,
    dateRange: state.dateRange,
    metric: metric
  })), /*#__PURE__*/_react.default.createElement(_charts.KubernetesCharts, {
    assetId: asset.id,
    dataView: metrics.dataView,
    dateRange: state.dateRange
  }));
};
exports.HostMetrics = HostMetrics;