"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useKubernetesCharts = exports.useHostKpiCharts = exports.useHostCharts = void 0;
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useHostCharts = ({
  metric,
  dataViewId,
  options
}) => {
  const {
    value: charts = [],
    error
  } = (0, _useAsync.default)(async () => {
    const hostCharts = await getHostsCharts({
      metric,
      options
    });
    return hostCharts.map(chart => ({
      ...chart,
      ...(dataViewId && {
        dataset: {
          index: dataViewId
        }
      })
    }));
  }, [dataViewId]);
  return {
    charts,
    error
  };
};
exports.useHostCharts = useHostCharts;
const useKubernetesCharts = ({
  dataViewId,
  options
}) => {
  const model = (0, _common.findInventoryModel)('host');
  const {
    value: charts = [],
    error
  } = (0, _useAsync.default)(async () => {
    const {
      kibernetesNode
    } = await model.metrics.getCharts();
    const items = options !== null && options !== void 0 && options.overview ? [kibernetesNode.xy.nodeCpuCapacity, kibernetesNode.xy.nodeMemoryCapacity] : [kibernetesNode.xy.nodeCpuCapacity, kibernetesNode.xy.nodeMemoryCapacity, kibernetesNode.xy.nodeDiskCapacity, kibernetesNode.xy.nodePodCapacity];
    return items.map(chart => {
      return {
        ...chart,
        ...(dataViewId && {
          dataset: {
            index: dataViewId
          }
        })
      };
    });
  }, [dataViewId, options === null || options === void 0 ? void 0 : options.overview]);
  return {
    charts,
    error
  };
};
exports.useKubernetesCharts = useKubernetesCharts;
const getSubtitleFromFormula = value => value.startsWith('max') ? _i18n.i18n.translate('xpack.infra.hostsViewPage.kpi.subtitle.max', {
  defaultMessage: 'Max'
}) : _i18n.i18n.translate('xpack.infra.assetDetails.kpi.subtitle.average', {
  defaultMessage: 'Average'
});
const useHostKpiCharts = ({
  dataViewId,
  options
}) => {
  const {
    value: charts = []
  } = (0, _useAsync.default)(async () => {
    const model = (0, _common.findInventoryModel)('host');
    const {
      cpu,
      memory,
      disk
    } = await model.metrics.getCharts();
    return [cpu.metric.cpuUsage, cpu.metric.normalizedLoad1m, memory.metric.memoryUsage, disk.metric.diskUsage].map(chart => ({
      ...chart,
      seriesColor: options === null || options === void 0 ? void 0 : options.seriesColor,
      decimals: 1,
      subtitle: options !== null && options !== void 0 && options.getSubtitle ? options === null || options === void 0 ? void 0 : options.getSubtitle(chart.value) : getSubtitleFromFormula(chart.value),
      ...(dataViewId && {
        dataset: {
          index: dataViewId
        }
      })
    }));
  }, [dataViewId, options === null || options === void 0 ? void 0 : options.seriesColor, options === null || options === void 0 ? void 0 : options.getSubtitle]);
  return charts;
};
exports.useHostKpiCharts = useHostKpiCharts;
const getHostsCharts = async ({
  metric,
  options
}) => {
  const model = (0, _common.findInventoryModel)('host');
  const {
    cpu,
    memory,
    network,
    disk,
    logs
  } = await model.metrics.getCharts();
  switch (metric) {
    case 'cpu':
      return options !== null && options !== void 0 && options.overview ? [cpu.xy.cpuUsage, cpu.xy.normalizedLoad1m] : [cpu.xy.cpuUsage, cpu.xy.cpuUsageBreakdown, cpu.xy.normalizedLoad1m, cpu.xy.loadBreakdown];
    case 'memory':
      return options !== null && options !== void 0 && options.overview ? [memory.xy.memoryUsage] : [memory.xy.memoryUsage, memory.xy.memoryUsageBreakdown];
    case 'network':
      return [network.xy.rxTx];
    case 'disk':
      return options !== null && options !== void 0 && options.overview ? [disk.xy.diskUsageByMountPoint, disk.xy.diskIOReadWrite] : [disk.xy.diskUsageByMountPoint, disk.xy.diskIOReadWrite, disk.xy.diskThroughputReadWrite];
    case 'log':
      return [logs.xy.logRate];
    default:
      return [];
  }
};