"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchCustomDashboards = useFetchCustomDashboards;
var _react = require("react");
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _pipeable = require("fp-ts/lib/pipeable");
var _custom_dashboards_api = require("../../../../common/http_api/custom_dashboards_api");
var _use_http_request = require("../../../hooks/use_http_request");
var _runtime_types = require("../../../../common/runtime_types");
var _use_request_observable = require("./use_request_observable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchCustomDashboards({
  assetType
}) {
  const {
    request$
  } = (0, _use_request_observable.useRequestObservable)();
  const decodeResponse = response => {
    return (0, _pipeable.pipe)(_custom_dashboards_api.InfraGetCustomDashboardsResponseBodyRT.decode(response), (0, _Either.fold)((0, _runtime_types.throwErrors)(_runtime_types.createPlainError), _function.identity));
  };
  const {
    error,
    loading,
    response,
    makeRequest
  } = (0, _use_http_request.useHTTPRequest)(`/api/infra/${assetType}/custom-dashboards`, 'GET', undefined, decodeResponse, undefined, undefined, true);
  (0, _react.useEffect)(() => {
    if (request$) {
      request$.next(makeRequest);
    } else {
      makeRequest();
    }
  }, [makeRequest, request$]);
  return {
    error: error && error.message || null,
    loading,
    dashboards: response,
    reload: makeRequest
  };
}