"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FETCH_STATUS = void 0;
exports.useDashboardFetcher = useDashboardFetcher;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_kibana = require("../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let FETCH_STATUS = exports.FETCH_STATUS = /*#__PURE__*/function (FETCH_STATUS) {
  FETCH_STATUS["LOADING"] = "loading";
  FETCH_STATUS["SUCCESS"] = "success";
  FETCH_STATUS["FAILURE"] = "failure";
  FETCH_STATUS["NOT_INITIATED"] = "not_initiated";
  return FETCH_STATUS;
}({});
function useDashboardFetcher(query = '') {
  const {
    services: {
      dashboard
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    notifications
  } = (0, _public.useKibana)();
  const [result, setResult] = (0, _react.useState)({
    data: [],
    status: FETCH_STATUS.NOT_INITIATED
  });
  (0, _react.useEffect)(() => {
    const getDashboards = async () => {
      setResult({
        data: [],
        status: FETCH_STATUS.LOADING
      });
      try {
        const findDashboardsService = await (dashboard === null || dashboard === void 0 ? void 0 : dashboard.findDashboardsService());
        const data = await findDashboardsService.search({
          search: query,
          size: 1000
        });
        setResult({
          data: data.hits,
          status: FETCH_STATUS.SUCCESS
        });
      } catch (error) {
        setResult({
          data: [],
          status: FETCH_STATUS.FAILURE
        });
        notifications.toasts.danger({
          title: _i18n.i18n.translate('xpack.infra.fetchingDashboards.addFailure.toast.title', {
            defaultMessage: 'Error while fetching dashboards'
          }),
          body: error.message
        });
      }
    };
    getDashboards();
  }, [dashboard, notifications.toasts, query]);
  return result;
}