"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostKpiCharts = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _kpi = require("./kpi");
var _use_metrics_charts = require("../../hooks/use_metrics_charts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HostKpiCharts = ({
  dateRange,
  dataView,
  filters,
  options,
  query,
  searchSessionId,
  loading = false
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const charts = (0, _use_metrics_charts.useHostKpiCharts)({
    dataViewId: dataView === null || dataView === void 0 ? void 0 : dataView.id,
    options: {
      getSubtitle: options === null || options === void 0 ? void 0 : options.getSubtitle,
      seriesColor: euiTheme.colors.lightestShade
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, charts.map((chartProps, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index
  }, /*#__PURE__*/_react.default.createElement(_kpi.Kpi, (0, _extends2.default)({}, chartProps, {
    dateRange: dateRange,
    filters: filters,
    query: query,
    searchSessionId: searchSessionId,
    loading: loading
  })))));
};
exports.HostKpiCharts = HostKpiCharts;