"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsTooltipContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _link_to_alerts_page = require("../links/link_to_alerts_page");
var _constants = require("../../shared/alerts/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertsTooltipContent = exports.AlertsTooltipContent = /*#__PURE__*/_react.default.memo(() => {
  const onClick = e => {
    e.stopPropagation();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    onClick: onClick
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.alerts.tooltip.alertsLabel",
    defaultMessage: "Showing alerts for this host. You can create and manage alerts in {alerts}",
    values: {
      alerts: /*#__PURE__*/_react.default.createElement(_link_to_alerts_page.LinkToAlertsHomePage, null)
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.alerts.tooltip.documentationLabel",
    defaultMessage: "See {documentation} for more information",
    values: {
      documentation: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "infraAssetDetailsTooltipDocumentationLink",
        href: _constants.ALERTS_DOC_HREF,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.assetDetails.alerts.tooltip.documentationLink",
        defaultMessage: "documentation"
      }))
    }
  })));
});