"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KubernetesCharts = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _use_metrics_charts = require("../hooks/use_metrics_charts");
var _section = require("../components/section");
var _section_title = require("../components/section_title");
var _translations = require("../translations");
var _constants = require("../constants");
var _charts_grid = require("../charts_grid/charts_grid");
var _chart = require("./chart");
var _use_integration_check = require("../hooks/use_integration_check");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KubernetesCharts = exports.KubernetesCharts = /*#__PURE__*/_react.default.forwardRef(({
  assetId,
  dataView,
  dateRange,
  onShowAll,
  overview
}, ref) => {
  const {
    charts
  } = (0, _use_metrics_charts.useKubernetesCharts)({
    dataViewId: dataView === null || dataView === void 0 ? void 0 : dataView.id,
    options: {
      overview
    }
  });
  const hasIntegration = (0, _use_integration_check.useIntegrationCheck)({
    dependsOn: _constants.INTEGRATIONS.kubernetes
  });
  if (!hasIntegration) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_section.Section, {
    title: /*#__PURE__*/_react.default.createElement(_section_title.SectionTitle, {
      title: _translations.HOST_METRIC_GROUP_TITLES.kubernetes
    }),
    "data-test-subj": "infraAssetDetailsKubernetesChartsSection",
    id: "kubernetes",
    ref: ref,
    extraAction: onShowAll ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "infraAssetDetailsKubernetesChartsShowAllButton",
      onClick: () => onShowAll('kubernetes'),
      size: "xs",
      flush: "both",
      iconSide: "right",
      iconType: "sortRight"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.assetDetails.charts.kubernetes.showAllButton",
      defaultMessage: "Show all"
    })) : null
  }, /*#__PURE__*/_react.default.createElement(_charts_grid.ChartsGrid, {
    columns: 2
  }, charts.map(chart => /*#__PURE__*/_react.default.createElement(_chart.Chart, (0, _extends2.default)({
    key: chart.id
  }, chart, {
    assetId: assetId,
    dateRange: dateRange,
    queryField: (0, _common.findInventoryFields)('host').id
  })))));
});