"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostCharts = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _css = require("@emotion/css");
var _visualizations = require("../../../common/visualizations");
var _translations = require("../translations");
var _section = require("../components/section");
var _charts_grid = require("../charts_grid/charts_grid");
var _chart = require("./chart");
var _use_metrics_charts = require("../hooks/use_metrics_charts");
var _section_title = require("../components/section_title");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FRAGMENT_BASE = 'key-metrics';
const HostCharts = exports.HostCharts = /*#__PURE__*/_react.default.forwardRef(({
  assetId,
  dataView,
  dateRange,
  metric,
  onShowAll,
  overview = false
}, ref) => {
  const {
    charts
  } = (0, _use_metrics_charts.useHostCharts)({
    metric,
    dataViewId: dataView === null || dataView === void 0 ? void 0 : dataView.id,
    options: {
      overview
    }
  });
  return /*#__PURE__*/_react.default.createElement(_section.Section, {
    title: /*#__PURE__*/_react.default.createElement(_section_title.TitleWithTooltip, {
      title: _translations.HOST_METRIC_GROUP_TITLES[metric],
      tooltipContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.assetDetails.charts.host.toolTip",
        defaultMessage: "See host-related {link} for more information",
        values: {
          link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "infraAssetDetailsViewHostMetricsDocumentationLink",
            href: `${_visualizations.HOST_METRICS_DOC_HREF}#${FRAGMENT_BASE}-${metric}`,
            target: "_blank",
            className: (0, _css.cx)({
              [(0, _css.css)`
                            text-transform: lowercase;
                          `]: metric !== 'cpu'
            })
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.infra.assetDetails.charts.host.toolTip.linkText",
            defaultMessage: "{metric} metrics",
            values: {
              metric: _translations.HOST_METRIC_GROUP_TITLES[metric]
            }
          }))
        }
      }))
    }),
    "data-test-subj": `infraAssetDetailsHostChartsSection${metric}`,
    id: metric,
    ref: ref,
    extraAction: onShowAll ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "infraAssetDetailsHostChartsShowAllButton",
      onClick: () => onShowAll(metric),
      size: "xs",
      flush: "both",
      iconSide: "right",
      iconType: "sortRight"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.assetDetails.charts.host.showAllButton",
      defaultMessage: "Show all"
    })) : null
  }, /*#__PURE__*/_react.default.createElement(_charts_grid.ChartsGrid, {
    columns: 2
  }, charts.map(chart => /*#__PURE__*/_react.default.createElement(_chart.Chart, (0, _extends2.default)({
    key: chart.id
  }, chart, {
    assetId: assetId,
    dateRange: dateRange,
    queryField: (0, _common.findInventoryFields)('host').id
  })))));
});