"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetDetails = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _flyout = require("./template/flyout");
var _page = require("./template/page");
var _context_providers = require("./context_providers");
var _use_tab_switcher = require("./hooks/use_tab_switcher");
var _use_data_views = require("./hooks/use_data_views");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ContentTemplate = ({
  tabs,
  links,
  renderMode
}) => {
  return renderMode.mode === 'flyout' ? /*#__PURE__*/_react.default.createElement(_flyout.Flyout, {
    tabs: tabs,
    links: links,
    closeFlyout: renderMode.closeFlyout
  }) : /*#__PURE__*/_react.default.createElement(_page.Page, {
    tabs: tabs,
    links: links
  });
};
const AssetDetails = ({
  tabs,
  links,
  renderMode,
  metricAlias,
  ...props
}) => {
  var _tabs$;
  return /*#__PURE__*/_react.default.createElement(_context_providers.ContextProviders, (0, _extends2.default)({}, props, {
    renderMode: renderMode
  }), /*#__PURE__*/_react.default.createElement(_use_tab_switcher.TabSwitcherProvider, {
    defaultActiveTabId: (_tabs$ = tabs[0]) === null || _tabs$ === void 0 ? void 0 : _tabs$.id
  }, /*#__PURE__*/_react.default.createElement(_use_data_views.DataViewsProvider, {
    metricAlias: metricAlias
  }, /*#__PURE__*/_react.default.createElement(ContentTemplate, {
    tabs: tabs,
    links: links,
    renderMode: renderMode
  }))));
};
exports.AssetDetails = AssetDetails;