"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.commonFlyoutTabs = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _types = require("../../components/asset_details/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const commonFlyoutTabs = exports.commonFlyoutTabs = [{
  id: _types.ContentTabIds.OVERVIEW,
  name: _i18n.i18n.translate('xpack.infra.assetDetails.tabs.overview', {
    defaultMessage: 'Overview'
  })
}, {
  id: _types.ContentTabIds.METADATA,
  name: _i18n.i18n.translate('xpack.infra.assetDetails.tabs.metadata', {
    defaultMessage: 'Metadata'
  })
}, {
  id: _types.ContentTabIds.METRICS,
  name: _i18n.i18n.translate('xpack.infra.assetDetails.tabs.metrics', {
    defaultMessage: 'Metrics'
  })
}, {
  id: _types.ContentTabIds.PROCESSES,
  name: _i18n.i18n.translate('xpack.infra.assetDetails.tabs.processes', {
    defaultMessage: 'Processes'
  })
}, {
  id: _types.ContentTabIds.PROFILING,
  name: _i18n.i18n.translate('xpack.infra.assetDetails.tabs.profiling', {
    defaultMessage: 'Universal Profiling'
  })
}, {
  id: _types.ContentTabIds.LOGS,
  name: _i18n.i18n.translate('xpack.infra.assetDetails.tabs.logs', {
    defaultMessage: 'Logs'
  })
}, {
  id: _types.ContentTabIds.ANOMALIES,
  name: _i18n.i18n.translate('xpack.infra.assetDetails.tabs.anomalies', {
    defaultMessage: 'Anomalies'
  })
}, {
  id: _types.ContentTabIds.OSQUERY,
  name: _i18n.i18n.translate('xpack.infra.assetDetails.tabs.osquery', {
    defaultMessage: 'Osquery'
  })
}, {
  id: _types.ContentTabIds.DASHBOARDS,
  name: _i18n.i18n.translate('xpack.infra.infra.nodeDetails.tabs.dashboards', {
    defaultMessage: 'Dashboards'
  }),
  append: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "accent"
  }, _i18n.i18n.translate('xpack.infra.customDashboards.newLabel', {
    defaultMessage: 'NEW'
  }))
}];