"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = exports.METRICS_APP_DATA_TEST_SUBJ = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/kibana-utils-plugin/public");
var _link_to_metrics = require("../pages/link_to/link_to_metrics");
var _metrics = require("../pages/metrics");
var _common_providers = require("./common_providers");
var _common_styles = require("./common_styles");
var _metrics_source = require("../containers/metrics_source");
var _plugin_config_context = require("../containers/plugin_config_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const METRICS_APP_DATA_TEST_SUBJ = exports.METRICS_APP_DATA_TEST_SUBJ = 'infraMetricsPage';
const renderApp = (core, plugins, pluginStart, pluginConfig, {
  element,
  history,
  setHeaderActionMenu,
  theme$
}, kibanaEnvironment) => {
  const storage = new _public.Storage(window.localStorage);
  (0, _common_styles.prepareMountElement)(element, METRICS_APP_DATA_TEST_SUBJ);
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(MetricsApp, {
    core: core,
    history: history,
    plugins: plugins,
    pluginStart: pluginStart,
    pluginConfig: pluginConfig,
    setHeaderActionMenu: setHeaderActionMenu,
    storage: storage,
    theme$: theme$,
    kibanaEnvironment: kibanaEnvironment
  }), element);
  return () => {
    plugins.data.search.session.clear();
    core.chrome.docTitle.reset();
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.renderApp = renderApp;
const MetricsApp = ({
  core,
  history,
  pluginStart,
  pluginConfig,
  plugins,
  setHeaderActionMenu,
  storage,
  theme$,
  kibanaEnvironment
}) => {
  var _uiCapabilities$infra;
  const uiCapabilities = core.application.capabilities;
  return /*#__PURE__*/_react.default.createElement(_common_providers.CoreProviders, {
    core: core,
    pluginStart: pluginStart,
    plugins: plugins,
    theme$: theme$,
    kibanaEnvironment: kibanaEnvironment
  }, /*#__PURE__*/_react.default.createElement(_common_providers.CommonInfraProviders, {
    appName: "Metrics UI",
    setHeaderActionMenu: setHeaderActionMenu,
    storage: storage,
    theme$: theme$,
    triggersActionsUI: plugins.triggersActionsUi
  }, /*#__PURE__*/_react.default.createElement(_metrics_source.SourceProvider, {
    sourceId: "default"
  }, /*#__PURE__*/_react.default.createElement(_plugin_config_context.PluginConfigProvider, {
    value: pluginConfig
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/link-to",
    component: _link_to_metrics.LinkToMetricsPage
  }), (uiCapabilities === null || uiCapabilities === void 0 ? void 0 : (_uiCapabilities$infra = uiCapabilities.infrastructure) === null || _uiCapabilities$infra === void 0 ? void 0 : _uiCapabilities$infra.show) && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/",
    component: _metrics.InfrastructurePage
  })))))));
};