"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-plugin/public");
var _charts = require("@elastic/charts");
var _uiTheme = require("@kbn/ui-theme");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _observabilityAlertDetails = require("@kbn/observability-alert-details");
var _use_kibana = require("../../../../../hooks/use_kibana");
var _criterion_preview_chart = require("../../expression_editor/criterion_preview_chart");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogsHistoryChart = ({
  rule,
  instanceId,
  groups
}) => {
  const {
    http,
    notifications
  } = (0, _use_kibana.useKibanaContextForPlugin)().services;
  // Show the Logs History Chart ONLY if we have one criteria
  // So always pull the first criteria
  const criteria = rule.params.criteria[0];
  const dateRange = {
    from: 'now-30d',
    to: 'now'
  };
  const executionTimeRange = {
    gte: _datemath.default.parse(dateRange.from).valueOf(),
    lte: _datemath.default.parse(dateRange.to, {
      roundUp: true
    }).valueOf(),
    buckets: 30
  };
  const {
    data: {
      histogramTriggeredAlerts,
      avgTimeToRecoverUS,
      totalTriggeredAlerts
    },
    isLoading,
    isError
  } = (0, _observabilityAlertDetails.useAlertsHistory)({
    http,
    featureIds: [_ruleDataUtils.AlertConsumers.LOGS],
    ruleId: rule.id,
    dateRange,
    instanceId
  });
  if (isError) {
    notifications === null || notifications === void 0 ? void 0 : notifications.toasts.addDanger({
      title: _i18n.i18n.translate('xpack.infra.alertDetails.logsAlertHistoryChart.error.toastTitle', {
        defaultMessage: 'Logs alerts history chart error'
      }),
      text: _i18n.i18n.translate('xpack.infra.alertDetails.logsAlertHistoryChart.error.toastDescription', {
        defaultMessage: `An error occurred when fetching logs alert history chart data`
      })
    });
  }
  const alertHistoryAnnotations = (histogramTriggeredAlerts === null || histogramTriggeredAlerts === void 0 ? void 0 : histogramTriggeredAlerts.filter(annotation => annotation.doc_count > 0).map(annotation => {
    return {
      dataValue: annotation.key,
      header: String(annotation.doc_count),
      // Only the date(without time) is needed here, uiSettings don't provide that
      details: (0, _moment.default)(annotation.key_as_string).format('yyyy-MM-DD')
    };
  })) || [];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    "data-test-subj": "logsHistoryChartAlertDetails"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.infra.logs.alertDetails.chartHistory.chartTitle', {
    defaultMessage: 'Logs threshold alerts history'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, _i18n.i18n.translate('xpack.infra.logs.alertDetails.chartHistory.last30days', {
    defaultMessage: 'Last 30 days'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  }) : totalTriggeredAlerts || '-')))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, _i18n.i18n.translate('xpack.infra.logs.alertDetails.chartHistory.alertsTriggered', {
    defaultMessage: 'Alerts triggered'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  }) : avgTimeToRecoverUS ? (0, _public.convertTo)({
    unit: 'minutes',
    microseconds: avgTimeToRecoverUS,
    extended: true
  }).formatted : '-')))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, _i18n.i18n.translate('xpack.infra.logs.alertDetails.chartHistory.avgTimeToRecover', {
    defaultMessage: 'Avg time to recover'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_criterion_preview_chart.CriterionPreview, {
    annotations: [/*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
      id: "annotations",
      key: 'annotationsAlertHistory',
      domainType: _charts.AnnotationDomainType.XDomain,
      dataValues: alertHistoryAnnotations,
      style: {
        line: {
          strokeWidth: 3,
          stroke: _uiTheme.euiThemeVars.euiColorDangerText,
          opacity: 1
        }
      },
      marker: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "warning",
        color: "danger"
      }),
      markerBody: annotationData => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "danger"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "white"
      }, annotationData.header)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xs"
      })),
      markerPosition: _charts.Position.Top
    })],
    ruleParams: {
      ...rule.params,
      timeSize: 1,
      timeUnit: 'd'
    },
    logViewReference: rule.params.logView,
    chartCriterion: criteria,
    showThreshold: true,
    executionTimeRange: executionTimeRange,
    filterSeriesByGroupName: groups === null || groups === void 0 ? void 0 : groups.map(group => group.value).join(', ')
  }));
};
// eslint-disable-next-line import/no-default-export
var _default = exports.default = LogsHistoryChart;
module.exports = exports.default;