"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerPutDataRetention = registerPutDataRetention;
var _configSchema = require("@kbn/config-schema");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerPutDataRetention({
  router,
  lib: {
    handleEsError
  }
}) {
  const paramsSchema = _configSchema.schema.object({
    name: _configSchema.schema.string()
  });
  const bodySchema = _configSchema.schema.object({
    dataRetention: _configSchema.schema.maybe(_configSchema.schema.string()),
    enabled: _configSchema.schema.maybe(_configSchema.schema.boolean())
  });
  router.put({
    path: (0, _.addBasePath)('/data_streams/{name}/data_retention'),
    validate: {
      params: paramsSchema,
      body: bodySchema
    }
  }, async (context, request, response) => {
    const {
      name
    } = request.params;
    const {
      dataRetention,
      enabled
    } = request.body;
    const {
      client
    } = (await context.core).elasticsearch;
    try {
      // Only when enabled is explicitly set to false, we delete the data retention policy.
      if (enabled === false) {
        await client.asCurrentUser.indices.deleteDataLifecycle({
          name
        });
      } else {
        // Otherwise, we create or update the data retention policy.
        await client.asCurrentUser.indices.putDataLifecycle({
          name,
          data_retention: dataRetention
        });
      }
      return response.ok({
        body: {
          success: true
        }
      });
    } catch (error) {
      return handleEsError({
        error,
        response
      });
    }
  });
}