"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailsPageMappingsContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _app_context = require("../../../../app_context");
var _document_fields_search = require("../../../../components/mappings_editor/components/document_fields/document_fields_search");
var _fields = require("../../../../components/mappings_editor/components/document_fields/fields");
var _search_fields = require("../../../../components/mappings_editor/components/document_fields/search_fields");
var _lib = require("../../../../components/mappings_editor/lib");
var _mappings_state_context = require("../../../../components/mappings_editor/mappings_state_context");
var _use_state_listener = require("../../../../components/mappings_editor/use_state_listener");
var _services = require("../../../../services");
var _components = require("../../../../components/mappings_editor/components");
var _api = require("../../../../services/api");
var _notification = require("../../../../services/notification");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFieldsFromState = state => {
  const getField = fieldId => {
    return state.fields.byId[fieldId];
  };
  const fields = () => {
    return state.fields.rootLevelFields.map(id => getField(id));
  };
  return fields();
};
const DetailsPageMappingsContent = ({
  index,
  data,
  jsonData,
  refetchMapping,
  showAboutMappings,
  isSemanticTextEnabled = false
}) => {
  const {
    services: {
      extensionsService
    },
    core: {
      getUrlForApp
    }
  } = (0, _app_context.useAppContext)();
  const state = (0, _mappings_state_context.useMappingsState)();
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const indexName = index.name;
  const pendingFieldListId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'pendingFieldListId'
  });
  const [isAddingFields, setAddingFields] = (0, _react.useState)(false);
  const newFieldsLength = (0, _react.useMemo)(() => {
    return Object.keys(state.fields.byId).length;
  }, [state.fields.byId]);
  const [previousState, setPreviousState] = (0, _react.useState)(state);
  const [previousStateFields, setPreviousStateFields] = (0, _react.useState)(getFieldsFromState(state));
  const [saveMappingError, setSaveMappingError] = (0, _react.useState)(undefined);
  const [isJSONVisible, setIsJSONVisible] = (0, _react.useState)(false);
  const onToggleChange = () => {
    setIsJSONVisible(!isJSONVisible);
  };
  const mappingsDefinition = (0, _lib.extractMappingsDefinition)(jsonData);
  const {
    parsedDefaultValue
  } = (0, _react.useMemo)(() => {
    if (mappingsDefinition === null) {
      return {
        multipleMappingsDeclared: true
      };
    }
    const {
      _source,
      _meta,
      _routing,
      _size,
      dynamic,
      properties,
      runtime,
      /* eslint-disable @typescript-eslint/naming-convention */
      numeric_detection,
      date_detection,
      dynamic_date_formats,
      dynamic_templates
      /* eslint-enable @typescript-eslint/naming-convention */
    } = mappingsDefinition;
    const parsed = {
      configuration: {
        _source,
        _meta,
        _routing,
        _size,
        dynamic,
        numeric_detection,
        date_detection,
        dynamic_date_formats
      },
      fields: properties,
      templates: {
        dynamic_templates
      },
      runtime
    };
    return {
      parsedDefaultValue: parsed,
      multipleMappingsDeclared: false
    };
  }, [mappingsDefinition]);
  (0, _use_state_listener.useMappingsStateListener)({
    value: parsedDefaultValue,
    status: 'disabled'
  });
  const onCancelAddingNewFields = (0, _react.useCallback)(() => {
    setAddingFields(!isAddingFields);

    //  reset mappings to previous state
    dispatch({
      type: 'editor.replaceMappings',
      value: {
        ...previousState,
        documentFields: {
          status: 'disabled',
          editor: 'default'
        }
      }
    });
  }, [isAddingFields, dispatch, previousState]);
  const addFieldButtonOnClick = (0, _react.useCallback)(() => {
    setAddingFields(!isAddingFields);

    // when adding new field, save previous state. This state is then used by FieldsList component to show only saved mappings.
    setPreviousStateFields(getFieldsFromState(state));
    setPreviousState(state);

    // reset mappings and change status to create field.
    dispatch({
      type: 'editor.replaceMappings',
      value: {
        ...state,
        fields: {
          ...state.fields,
          byId: {},
          rootLevelFields: []
        },
        documentFields: {
          status: 'creatingField',
          editor: 'default'
        }
      }
    });
  }, [dispatch, isAddingFields, state]);
  const updateMappings = (0, _react.useCallback)(async () => {
    try {
      const {
        error
      } = await (0, _api.updateIndexMappings)(indexName, (0, _lib.deNormalize)(state.fields));
      if (!error) {
        _notification.notificationService.showSuccessToast(_i18n.i18n.translate('xpack.idxMgmt.indexDetails.mappings.successfullyUpdatedIndexMappings', {
          defaultMessage: 'Index Mapping was successfully updated'
        }));
        refetchMapping();
      } else {
        setSaveMappingError(error.message);
      }
    } catch (exception) {
      setSaveMappingError(exception.message);
    }
  }, [state.fields, indexName, refetchMapping]);
  const onSearchChange = (0, _react.useCallback)(value => {
    if (isAddingFields) {
      setPreviousState({
        ...previousState,
        search: {
          term: value,
          result: (0, _lib.searchFields)(value, previousState.fields.byId)
        }
      });
    } else {
      dispatch({
        type: 'search:update',
        value
      });
    }
  }, [dispatch, previousState, isAddingFields]);
  const searchTerm = isAddingFields ? previousState.search.term.trim() : state.search.term.trim();
  const jsonBlock = /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true,
    "data-test-subj": "indexDetailsMappingsCodeBlock",
    css: (0, _react2.css)`
        height: 100%;
      `
  }, data);
  const searchResultComponent = isAddingFields ? /*#__PURE__*/_react.default.createElement(_search_fields.SearchResult, {
    result: previousState.search.result,
    documentFieldsState: previousState.documentFields
  }) : /*#__PURE__*/_react.default.createElement(_search_fields.SearchResult, {
    result: state.search.result,
    documentFieldsState: state.documentFields
  });
  const fieldsListComponent = isAddingFields ? /*#__PURE__*/_react.default.createElement(_fields.FieldsList, {
    fields: previousStateFields,
    state: previousState,
    setPreviousState: setPreviousState,
    isAddingFields: isAddingFields
  }) : /*#__PURE__*/_react.default.createElement(_fields.FieldsList, {
    fields: getFieldsFromState(state),
    state: state,
    isAddingFields: isAddingFields
  });
  const fieldSearchComponent = isAddingFields ? /*#__PURE__*/_react.default.createElement(_document_fields_search.DocumentFieldsSearch, {
    searchValue: previousState.search.term,
    onSearchChange: onSearchChange,
    disabled: isJSONVisible
  }) : /*#__PURE__*/_react.default.createElement(_document_fields_search.DocumentFieldsSearch, {
    searchValue: state.search.term,
    onSearchChange: onSearchChange,
    disabled: isJSONVisible
  });
  const treeViewBlock = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, mappingsDefinition === null ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    color: "danger",
    iconType: "error",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.mappings.invalidMappingKeysErrorMessageTitle",
      defaultMessage: "Unable to load the mapping"
    })),
    body: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.mappings.invalidMappingKeysErrorMessageBody",
      defaultMessage: "The mapping contains invalid keys. Please provide a mapping with valid keys."
    }))
  }) : searchTerm !== '' ? searchResultComponent : fieldsListComponent);
  const errorSavingMappings = saveMappingError && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    "data-test-subj": "indexDetailsSaveMappingsError",
    iconType: "error",
    title: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.mappings.error.title', {
      defaultMessage: 'Error saving mapping'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.indexDetails.mappings.error.description",
    defaultMessage: "Error saving mapping: {errorMessage}",
    values: {
      errorMessage: saveMappingError
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
  return (
    /*#__PURE__*/
    // using "rowReverse" to keep docs links on the top of the mappings code block on smaller screen
    _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      wrap: true,
      direction: "rowReverse",
      css: (0, _react2.css)`
          height: 100%;
        `
    }, showAboutMappings && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 1,
      css: (0, _react2.css)`
              min-width: 400px;
            `
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      grow: false,
      paddingSize: "l"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "iInCircle"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.mappings.docsCardTitle",
      defaultMessage: "About index mappings"
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.mappings.docsCardDescription",
      defaultMessage: "Your documents are made up of a set of fields. Index mappings give each field a type (such as keyword, number, or date) and additional subfields. These index mappings determine the functions available in your relevance tuning and search experience."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "indexDetailsMappingsDocsLink",
      href: _services.documentationService.getMappingDocumentationLink(),
      target: "_blank",
      external: true
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.mappings.docsCardLink",
      defaultMessage: "Learn more about mappings"
    }))), extensionsService.indexMappingsContent && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), extensionsService.indexMappingsContent.renderContent({
      index,
      getUrlForApp
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, fieldSearchComponent), !index.hidden && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, !isAddingFields ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: addFieldButtonOnClick,
      iconType: "plusInCircle",
      color: "text",
      size: "m",
      "data-test-subj": "indexDetailsMappingsAddField"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.mappings.addNewField",
      defaultMessage: "Add field"
    })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: updateMappings,
      color: "success",
      fill: true,
      disabled: newFieldsLength === 0,
      "data-test-subj": "indexDetailsMappingsSaveMappings"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.mappings.saveMappings",
      defaultMessage: "Save mappings"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
      "data-test-subj": "indexDetailsMappingsToggleViewButton",
      "aria-label": _i18n.i18n.translate('xpack.idxMgmt.indexDetails.mappings.mappingsViewButtonGroupAriaLabel', {
        defaultMessage: 'Mappings View Button Group'
      }),
      onClick: onToggleChange
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      hasActiveFilters: !isJSONVisible,
      withNext: true
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.mappings.tableView",
      defaultMessage: "List"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      hasActiveFilters: isJSONVisible
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.mappings.json",
      defaultMessage: "JSON"
    }))))), errorSavingMappings, isAddingFields && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      id: pendingFieldListId,
      initialIsOpen: true,
      buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        paddingSize: "s",
        hasShadow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "baseline",
        "data-test-subj": "indexDetailsMappingsPendingBlock"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: 6
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "m"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexDetails.mappings.addMappingPendingBlock",
        defaultMessage: "Pending fields"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
        color: newFieldsLength > 0 ? 'accent' : 'subdued',
        size: "m"
      }, newFieldsLength))))
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasShadow: false
    }, newFieldsLength <= 0 ? /*#__PURE__*/_react.default.createElement(_components.DocumentFields, {
      onCancelAddingNewFields: onCancelAddingNewFields,
      isAddingFields: isAddingFields,
      isSemanticTextEnabled: isSemanticTextEnabled,
      indexName: indexName
    }) : /*#__PURE__*/_react.default.createElement(_components.DocumentFields, {
      isAddingFields: isAddingFields,
      isSemanticTextEnabled: isSemanticTextEnabled,
      indexName: indexName
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      css: (0, _react2.css)`
              min-width: 600px;
              height: 100%;
            `
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasShadow: false,
      paddingSize: "none"
    }, isJSONVisible ? jsonBlock : treeViewBlock)))))
  );
};
exports.DetailsPageMappingsContent = DetailsPageMappingsContent;