"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndexManagementDependencies = getIndexManagementDependencies;
exports.mountManagementSection = mountManagementSection;
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _plugin = require("../../common/constants/plugin");
var _breadcrumbs = require("./services/breadcrumbs");
var _documentation = require("./services/documentation");
var _services = require("./services");
var _ = require(".");
var _api = require("./services/api");
var _notification = require("./services/notification");
var _http = require("./services/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function initSetup({
  usageCollection,
  core
}) {
  const {
    http,
    notifications
  } = core;
  _http.httpService.setup(http);
  _notification.notificationService.setup(notifications);
  const uiMetricService = new _services.UiMetricService(_constants.UIM_APP_NAME);
  (0, _api.setUiMetricService)(uiMetricService);
  uiMetricService.setup(usageCollection);
  return {
    uiMetricService
  };
}
function getIndexManagementDependencies({
  core,
  usageCollection,
  extensionsService,
  history,
  isFleetEnabled,
  kibanaVersion,
  config,
  cloud,
  startDependencies,
  uiMetricService
}) {
  const {
    docLinks,
    application,
    uiSettings,
    settings
  } = core;
  const {
    url
  } = startDependencies.share;
  return {
    core: {
      getUrlForApp: application.getUrlForApp,
      ...core
    },
    plugins: {
      usageCollection,
      isFleetEnabled,
      share: startDependencies.share,
      cloud,
      console: startDependencies.console
    },
    services: {
      httpService: _http.httpService,
      notificationService: _notification.notificationService,
      uiMetricService,
      extensionsService
    },
    config,
    history,
    setBreadcrumbs: _breadcrumbs.breadcrumbService.setBreadcrumbs,
    uiSettings,
    settings,
    url,
    docLinks,
    kibanaVersion
  };
}
async function mountManagementSection({
  coreSetup,
  usageCollection,
  params,
  extensionsService,
  isFleetEnabled,
  kibanaVersion,
  config,
  cloud
}) {
  const {
    element,
    setBreadcrumbs,
    history
  } = params;
  const [core, startDependencies] = await coreSetup.getStartServices();
  const {
    docLinks,
    chrome: {
      docTitle
    }
  } = core;
  docTitle.change(_plugin.PLUGIN.getI18nName(_i18n.i18n));
  _breadcrumbs.breadcrumbService.setup(setBreadcrumbs);
  _documentation.documentationService.setup(docLinks);
  const {
    uiMetricService
  } = initSetup({
    usageCollection,
    core
  });
  const appDependencies = getIndexManagementDependencies({
    cloud,
    config,
    core,
    extensionsService,
    history,
    isFleetEnabled,
    kibanaVersion,
    startDependencies,
    uiMetricService,
    usageCollection
  });
  const unmountAppCallback = (0, _.renderApp)(element, {
    core,
    dependencies: appDependencies
  });
  return () => {
    docTitle.reset();
    unmountAppCallback();
  };
}