"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReferenceFieldSelects = void 0;
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../../../../services");
var _lib = require("../../../lib");
var _shared_imports = require("../../../shared_imports");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReferenceFieldSelects = ({
  onChange,
  'data-test-subj': dataTestSubj,
  indexName
}) => {
  const {
    form
  } = (0, _shared_imports.useForm)();
  const {
    subscribe
  } = form;
  const {
    data
  } = (0, _services.useLoadIndexMappings)(indexName !== null && indexName !== void 0 ? indexName : '');
  const referenceFieldOptions = [];
  if (data && data.mappings && data.mappings.properties) {
    Object.keys(data.mappings.properties).forEach(key => {
      const field = data.mappings.properties[key];
      if (field.type === 'text') {
        referenceFieldOptions.push({
          value: key,
          inputDisplay: key
        });
      }
    });
  }
  const fieldConfigReferenceField = (0, _lib.getFieldConfig)('reference_field');
  (0, _react.useEffect)(() => {
    const subscription = subscribe(updateData => {
      const formData = updateData.data.internal;
      const value = formData.main;
      onChange(value);
    });
    return subscription.unsubscribe;
  }, [subscribe, onChange]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "main",
    config: fieldConfigReferenceField
  }, field => /*#__PURE__*/_react.default.createElement(_shared_imports.SuperSelectField, {
    field: field,
    euiFieldProps: {
      options: referenceFieldOptions
    },
    "data-test-subj": dataTestSubj
  })));
};
exports.ReferenceFieldSelects = ReferenceFieldSelects;