"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InferenceIdSelects = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _component_templates_context = require("../../../../component_templates/component_templates_context");
var _lib = require("../../../lib");
var _shared_imports = require("../../../shared_imports");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InferenceIdSelects = ({
  onChange,
  'data-test-subj': dataTestSubj
}) => {
  var _inferenceModels$data;
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue: {
      main: 'elser_model_2'
    }
  });
  const {
    subscribe
  } = form;
  const {
    api
  } = (0, _component_templates_context.useComponentTemplatesContext)();
  const [inferenceModels, setInferenceModels] = (0, _react.useState)({
    data: []
  });
  const fieldConfigModelId = (0, _lib.getFieldConfig)('inference_id');
  const defaultInferenceIds = [{
    value: 'elser_model_2',
    inputDisplay: 'elser_model_2'
  }, {
    value: 'e5',
    inputDisplay: 'e5'
  }];
  const inferenceIdOptionsFromModels = (inferenceModels === null || inferenceModels === void 0 ? void 0 : (_inferenceModels$data = inferenceModels.data) === null || _inferenceModels$data === void 0 ? void 0 : _inferenceModels$data.map(model => ({
    value: model.model_id,
    inputDisplay: model.model_id
  }))) || [];
  const inferenceIdOptions = [...defaultInferenceIds, ...inferenceIdOptionsFromModels];
  (0, _react.useEffect)(() => {
    const fetchInferenceModels = async () => {
      const models = await api.getInferenceModels();
      setInferenceModels(models);
    };
    fetchInferenceModels();
  }, [api]);
  (0, _react.useEffect)(() => {
    const subscription = subscribe(updateData => {
      const formData = updateData.data.internal;
      const value = formData.main;
      onChange(value);
    });
    return subscription.unsubscribe;
  }, [subscribe, onChange]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "main",
    config: fieldConfigModelId
  }, field => /*#__PURE__*/_react.default.createElement(_shared_imports.SuperSelectField, {
    field: field,
    euiFieldProps: {
      options: inferenceIdOptions
    },
    "data-test-subj": dataTestSubj
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: "warning",
    title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.noReferenceModelStartWarningMessage', {
      defaultMessage: 'The referenced model for this inference endpoint will be started when adding this field.'
    })
  }))));
};
exports.InferenceIdSelects = InferenceIdSelects;