"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnrichPoliciesWithPrivileges = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _shared_imports = require("../../../shared_imports");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnrichPoliciesWithPrivileges = ({
  children
}) => {
  const {
    apiError
  } = (0, _shared_imports.useAuthorizationContext)();
  if (apiError) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.home.enrichPolicies.checkingPrivilegesErrorMessage",
        defaultMessage: "Error fetching user privileges from the server."
      }),
      error: apiError
    });
  }
  return /*#__PURE__*/_react.default.createElement(_shared_imports.WithPrivileges, {
    privileges: _constants.ENRICH_POLICIES_REQUIRED_PRIVILEGES.map(privilege => `cluster.${privilege}`)
  }, ({
    isLoading,
    hasPrivileges,
    privilegesMissing
  }) => {
    if (isLoading) {
      return /*#__PURE__*/_react.default.createElement(_shared_imports.PageLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.home.enrichPolicies.checkingPrivilegesDescription",
        defaultMessage: "Checking privileges\u2026"
      }));
    }
    if (!hasPrivileges) {
      return /*#__PURE__*/_react.default.createElement(_shared_imports.NotAuthorizedSection, {
        dataTestSubj: "enrichPoliciesInsuficientPrivileges",
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.idxMgmt.home.enrichPolicies.deniedPrivilegeTitle",
          defaultMessage: "Manage enrich privileges required"
        }),
        message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.idxMgmt.home.enrichPolicies.deniedPrivilegeDescription",
          defaultMessage: "To use Enrich Policies, you must have the following cluster privileges: {missingPrivileges}.",
          values: {
            missingPrivileges: privilegesMissing.cluster.join(', ')
          }
        })
      });
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  });
};
exports.EnrichPoliciesWithPrivileges = EnrichPoliciesWithPrivileges;