"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComponentTemplateEdit = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _breadcrumbs = require("../../../../services/breadcrumbs");
var _component_templates_context = require("../../component_templates_context");
var _shared_imports = require("../../shared_imports");
var _component_template_form = require("../component_template_form");
var _redirect_path = require("../../../../hooks/redirect_path");
var _constants = require("../../constants");
var _use_step_from_query_string = require("../use_step_from_query_string");
var _use_datastreams_rollover = require("../component_template_datastreams_rollover/use_datastreams_rollover");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ComponentTemplateEdit = ({
  match: {
    params: {
      name
    }
  },
  history
}) => {
  const {
    api
  } = (0, _component_templates_context.useComponentTemplatesContext)();
  const {
    activeStep: defaultActiveStep,
    updateStep
  } = (0, _use_step_from_query_string.useStepFromQueryString)(history);
  const redirectTo = (0, _redirect_path.useRedirectPath)(history);
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [saveError, setSaveError] = (0, _react.useState)(null);
  const decodedName = (0, _shared_imports.attemptToURIDecode)(name);
  const {
    error,
    data: componentTemplate,
    isLoading
  } = api.useLoadComponentTemplate(decodedName);
  const {
    data: dataStreamResponse
  } = api.useLoadComponentTemplatesDatastream(decodedName);
  const dataStreams = (0, _react.useMemo)(() => {
    var _dataStreamResponse$d;
    return (_dataStreamResponse$d = dataStreamResponse === null || dataStreamResponse === void 0 ? void 0 : dataStreamResponse.data_streams) !== null && _dataStreamResponse$d !== void 0 ? _dataStreamResponse$d : [];
  }, [dataStreamResponse]);
  const {
    showDatastreamRolloverModal
  } = (0, _use_datastreams_rollover.useDatastreamsRollover)();
  (0, _react.useEffect)(() => {
    _breadcrumbs.breadcrumbService.setBreadcrumbs(_breadcrumbs.IndexManagementBreadcrumb.componentTemplateEdit);
  }, []);
  const onSave = async updatedComponentTemplate => {
    var _updatedComponentTemp;
    setIsSaving(true);
    setSaveError(null);
    const {
      error: saveErrorObject
    } = await api.updateComponentTemplate(updatedComponentTemplate);
    setIsSaving(false);
    if (saveErrorObject) {
      setSaveError(saveErrorObject);
      return;
    }
    if (((_updatedComponentTemp = updatedComponentTemplate._meta) === null || _updatedComponentTemp === void 0 ? void 0 : _updatedComponentTemp.managed_by) === _constants.MANAGED_BY_FLEET) {
      await showDatastreamRolloverModal(updatedComponentTemplate.name);
    }
    redirectTo({
      pathname: encodeURI(`/component_templates/${encodeURIComponent(updatedComponentTemplate.name)}`)
    });
  };
  const clearSaveError = () => {
    setSaveError(null);
  };
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.PageLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateEdit.loadingDescription",
      defaultMessage: "Loading component template\u2026"
    }));
  }
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.componentTemplateEdit.loadComponentTemplateError",
        defaultMessage: "Error loading component template"
      }),
      error: error,
      "data-test-subj": "loadComponentTemplateError"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    restrictWidth: true,
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "pageTitle"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateEdit.editPageTitle",
      defaultMessage: "Edit component template '{name}'",
      values: {
        name: decodedName
      }
    })),
    bottomBorder: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), (componentTemplate === null || componentTemplate === void 0 ? void 0 : componentTemplate.deprecated) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateEdit.deprecatedTemplateWarningTitle",
      defaultMessage: "This component template is deprecated"
    }),
    iconType: "warning",
    color: "warning",
    "data-test-subj": "deprecatedTemplateCallout"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.componentTemplateEdit.deprecatedTemplateWarningDescription",
    defaultMessage: "This component template is no longer supported and might be removed in a future release. Instead, use one of the other component templates available or create a new one."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_component_template_form.ComponentTemplateForm, {
    defaultValue: componentTemplate,
    dataStreams: dataStreams,
    defaultActiveWizardSection: defaultActiveStep,
    onStepChange: updateStep,
    onSave: onSave,
    isSaving: isSaving,
    saveError: saveError,
    clearSaveError: clearSaveError,
    isEditing: true
  }));
};
exports.ComponentTemplateEdit = ComponentTemplateEdit;