"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPolicyEditPath = exports.getPolicyCreatePath = exports.getPoliciesListPath = exports.getIndicesListPath = exports.ROUTES = void 0;
var _public = require("@kbn/index-management-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ROUTES = exports.ROUTES = {
  list: '/policies',
  edit: '/policies/edit/:policyName?',
  create: '/policies/edit'
};
const getPolicyEditPath = policyName => {
  return encodeURI(`/policies/edit/${encodeURIComponent(policyName)}`);
};
exports.getPolicyEditPath = getPolicyEditPath;
const getPolicyCreatePath = () => {
  return ROUTES.create;
};
exports.getPolicyCreatePath = getPolicyCreatePath;
const getPoliciesListPath = () => {
  return ROUTES.list;
};
exports.getPoliciesListPath = getPoliciesListPath;
const getIndicesListPath = (policyName, getUrlForApp) => getUrlForApp('management', {
  path: `/data/index_management${(0, _public.getIndexListUri)(`ilm.policy="${policyName}"`, true)}`
});
exports.getIndicesListPath = getIndicesListPath;