"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.untilPluginStartServicesReady = exports.uiActionsService = exports.trackUiMetric = exports.setKibanaServices = exports.securityService = exports.screenshotModeService = exports.filesService = exports.coreServices = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

let coreServices = exports.coreServices = void 0;
let filesService = exports.filesService = void 0;
let uiActionsService = exports.uiActionsService = void 0;
let screenshotModeService = exports.screenshotModeService = void 0;
let securityService = exports.securityService = void 0;
let trackUiMetric = exports.trackUiMetric = void 0;
const servicesReady$ = new _rxjs.BehaviorSubject(false);
const untilPluginStartServicesReady = () => {
  if (servicesReady$.value) return Promise.resolve();
  return new Promise(resolve => {
    const subscription = servicesReady$.subscribe(isInitialized => {
      if (isInitialized) {
        subscription.unsubscribe();
        resolve();
      }
    });
  });
};
exports.untilPluginStartServicesReady = untilPluginStartServicesReady;
const setKibanaServices = (kibanaCore, deps) => {
  exports.coreServices = coreServices = kibanaCore;
  exports.filesService = filesService = deps.files;
  exports.securityService = securityService = deps.security;
  exports.uiActionsService = uiActionsService = deps.uiActions;
  exports.screenshotModeService = screenshotModeService = deps.screenshotMode;
  servicesReady$.next(true);
};
exports.setKibanaServices = setKibanaServices;