"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.config = exports.KibanaConfig = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _fs = require("fs");
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const hostURISchema = _configSchema.schema.uri({
  scheme: ['http', 'https']
});
const configSchema = _configSchema.schema.object({
  hosts: _configSchema.schema.arrayOf(hostURISchema, {
    minSize: 1
  }),
  requestTimeout: _configSchema.schema.duration({
    defaultValue: '30s'
  }),
  ssl: _configSchema.schema.object({
    verificationMode: _configSchema.schema.oneOf([_configSchema.schema.literal('none'), _configSchema.schema.literal('certificate'), _configSchema.schema.literal('full')], {
      defaultValue: 'full'
    }),
    certificateAuthorities: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string(), {
      minSize: 1
    })])),
    certificate: _configSchema.schema.maybe(_configSchema.schema.string())
  })
});
const config = exports.config = {
  path: 'kibana',
  schema: configSchema
};
class KibanaConfig {
  constructor({
    logger,
    config: configService
  }) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    /**
     * Kibana hosts that the gateway will connect to.
     */
    (0, _defineProperty2.default)(this, "hosts", void 0);
    /**
     * Timeout after which HTTP requests to the Kibana hosts will be aborted.
     */
    (0, _defineProperty2.default)(this, "requestTimeout", void 0);
    /**
     * Settings to configure SSL connection between the gateway and Kibana hosts.
     */
    (0, _defineProperty2.default)(this, "ssl", void 0);
    this.logger = logger.get('kibana-config');
    this.config = configService.atPathSync('kibana');
    this.hosts = this.config.hosts;
    this.requestTimeout = this.config.requestTimeout;
    const {
      verificationMode
    } = this.config.ssl;
    const {
      certificate,
      certificateAuthorities
    } = this.readKeyAndCerts();
    this.ssl = {
      certificate,
      certificateAuthorities,
      verificationMode
    };
  }
  readKeyAndCerts() {
    const certificate = this.config.ssl.certificate ? readFile(this.config.ssl.certificate) : undefined;
    if (certificate) {
      this.logger.debug(`Reading certificate: ${this.config.ssl.certificate}`);
    }
    const certificateAuthorities = [];
    const ca = this.config.ssl.certificateAuthorities || [];
    for (const path of Array.isArray(ca) ? ca : [ca]) {
      this.logger.debug(`Adding certificate authority: ${path}`);
      certificateAuthorities.push(readFile(path));
    }
    return {
      certificate,
      certificateAuthorities: certificateAuthorities.length ? certificateAuthorities : undefined
    };
  }
}
exports.KibanaConfig = KibanaConfig;
const readFile = file => (0, _fs.readFileSync)(file, 'utf8');