"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GuideStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _guide_panel_step = require("./guide_panel_step.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const renderDescription = description => {
  if (typeof description === 'string') {
    return description;
  }
  const {
    descriptionText,
    linkText,
    linkUrl,
    isLinkExternal
  } = description;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, descriptionText, /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "guidePanelStepDescriptionLink",
    href: linkUrl,
    target: isLinkExternal ? '_blank' : ''
  }, linkText));
};
const GuideStep = ({
  accordionId,
  stepStatus,
  stepNumber,
  stepConfig,
  handleButtonClick,
  telemetryGuideId,
  isLoading
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const styles = (0, _guide_panel_step.getGuidePanelStepStyles)(euiTheme, stepStatus);
  const stepTitleContent = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, stepStatus === 'complete' ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "checkInCircleFilled",
    size: "l",
    color: euiTheme.colors.success
  }) : /*#__PURE__*/_react.default.createElement("span", {
    css: styles.stepNumber
  }, stepNumber)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    css: styles.stepTitle
  }, stepConfig.title)));
  const isAccordionOpen = stepStatus === 'in_progress' || stepStatus === 'active' || stepStatus === 'ready_to_complete';
  const getStepButtonLabel = () => {
    switch (stepStatus) {
      case 'active':
        return _i18n.i18n.translate('guidedOnboarding.dropdownPanel.startStepButtonLabel', {
          defaultMessage: 'Start'
        });
      case 'in_progress':
        return _i18n.i18n.translate('guidedOnboarding.dropdownPanel.continueStepButtonLabel', {
          defaultMessage: 'Continue'
        });
      case 'ready_to_complete':
        return _i18n.i18n.translate('guidedOnboarding.dropdownPanel.markDoneStepButtonLabel', {
          defaultMessage: 'Mark done'
        });
    }
    return '';
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "guidePanelStep"
  }, stepStatus === 'complete' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, stepTitleContent) : /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: accordionId,
    buttonContent: stepTitleContent,
    arrowDisplay: "right",
    initialIsOpen: isAccordionOpen
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "guidePanelStepDescription",
    css: styles.description
  }, stepConfig.description && /*#__PURE__*/_react.default.createElement("p", null, renderDescription(stepConfig.description)), stepConfig.descriptionList && /*#__PURE__*/_react.default.createElement("ul", null, stepConfig.descriptionList.map((description, index) => {
    return /*#__PURE__*/_react.default.createElement("li", {
      key: `description-${index}`
    }, renderDescription(description));
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), isAccordionOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isLoading: isLoading,
    onClick: handleButtonClick,
    fill: true
    // data-test-subj used for FS tracking and tests
    ,
    "data-test-subj": `onboarding--stepButton--${telemetryGuideId}--step${stepNumber}`
  }, getStepButtonLabel()))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "l"
  }));
};
exports.GuideStep = GuideStep;