"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stepInstallTransforms = stepInstallTransforms;
var _install = require("../../../elasticsearch/transform/install");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function stepInstallTransforms(context) {
  var _context$esReferences;
  const {
    packageInstallContext,
    esClient,
    savedObjectsClient,
    logger,
    force,
    authorizationHeader
  } = context;
  let esReferences = (_context$esReferences = context.esReferences) !== null && _context$esReferences !== void 0 ? _context$esReferences : [];
  ({
    esReferences
  } = await (0, _utils.withPackageSpan)('Install transforms', () => (0, _install.installTransforms)({
    packageInstallContext,
    esClient,
    savedObjectsClient,
    logger,
    esReferences,
    force,
    authorizationHeader
  })));
  return {
    esReferences
  };
}