"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migratePackagePolicyToV8140 = exports.migratePackagePolicyEnableCapsToV8140 = exports.migratePackagePolicyAddAntivirusRegistrationModeToV8140 = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ON_WRITE_SCAN_DEFAULT_VALUE = true;
const migratePackagePolicyToV8140 = packagePolicyDoc => {
  var _packagePolicyDoc$att;
  if (((_packagePolicyDoc$att = packagePolicyDoc.attributes.package) === null || _packagePolicyDoc$att === void 0 ? void 0 : _packagePolicyDoc$att.name) !== 'endpoint') {
    return {
      attributes: packagePolicyDoc.attributes
    };
  }
  const updatedPackagePolicyDoc = packagePolicyDoc;
  const input = updatedPackagePolicyDoc.attributes.inputs[0];
  if (input && input.config) {
    const policy = input.config.policy.value;
    policy.windows.malware.on_write_scan ??= policy.windows.malware.mode === 'off' ? false : ON_WRITE_SCAN_DEFAULT_VALUE;
    policy.mac.malware.on_write_scan ??= policy.mac.malware.mode === 'off' ? false : ON_WRITE_SCAN_DEFAULT_VALUE;
    policy.linux.malware.on_write_scan ??= policy.linux.malware.mode === 'off' ? false : ON_WRITE_SCAN_DEFAULT_VALUE;
  }
  return {
    attributes: updatedPackagePolicyDoc.attributes
  };
};
exports.migratePackagePolicyToV8140 = migratePackagePolicyToV8140;
const migratePackagePolicyEnableCapsToV8140 = packagePolicyDoc => {
  var _packagePolicyDoc$att2;
  if (((_packagePolicyDoc$att2 = packagePolicyDoc.attributes.package) === null || _packagePolicyDoc$att2 === void 0 ? void 0 : _packagePolicyDoc$att2.name) !== 'endpoint') {
    return {
      attributes: packagePolicyDoc.attributes
    };
  }
  const updatedPackagePolicyDoc = packagePolicyDoc;
  const input = updatedPackagePolicyDoc.attributes.inputs[0];
  if (input && input.config) {
    var _policy$linux$advance;
    const policy = input.config.policy.value;
    policy.linux.advanced = {
      ...policy.linux.advanced,
      events: {
        enable_caps: true,
        ...((_policy$linux$advance = policy.linux.advanced) === null || _policy$linux$advance === void 0 ? void 0 : _policy$linux$advance.events) // this comes second, so existing value is not overwritten by backfill
      }
    };
  }
  return {
    attributes: updatedPackagePolicyDoc.attributes
  };
};
exports.migratePackagePolicyEnableCapsToV8140 = migratePackagePolicyEnableCapsToV8140;
const migratePackagePolicyAddAntivirusRegistrationModeToV8140 = packagePolicyDoc => {
  var _packagePolicyDoc$att3;
  if (((_packagePolicyDoc$att3 = packagePolicyDoc.attributes.package) === null || _packagePolicyDoc$att3 === void 0 ? void 0 : _packagePolicyDoc$att3.name) !== 'endpoint') {
    return {
      attributes: packagePolicyDoc.attributes
    };
  }
  const updatedPackagePolicyDoc = packagePolicyDoc;
  const input = updatedPackagePolicyDoc.attributes.inputs[0];
  if (input && input.config) {
    const antivirusRegistration = input.config.policy.value.windows.antivirus_registration;
    antivirusRegistration.mode ??= antivirusRegistration.enabled ? 'enabled' : 'disabled';
  }
  return {
    attributes: updatedPackagePolicyDoc.attributes
  };
};
exports.migratePackagePolicyAddAntivirusRegistrationModeToV8140 = migratePackagePolicyAddAntivirusRegistrationModeToV8140;