"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = exports.READ_PACKAGE_INFO_AUTHZ = exports.INSTALL_PACKAGES_AUTHZ = void 0;
var _constants = require("../../../common/constants");
var _security = require("../../services/security");
var _constants2 = require("../../constants");
var _registry = require("../../services/epm/registry");
var _types = require("../../types");
var _handlers = require("./handlers");
var _file_handler = require("./file_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_FILE_SIZE_BYTES = 104857600; // 100MB

const INSTALL_PACKAGES_AUTHZ = exports.INSTALL_PACKAGES_AUTHZ = {
  integrations: {
    installPackages: true
  }
};
const READ_PACKAGE_INFO_AUTHZ = exports.READ_PACKAGE_INFO_AUTHZ = {
  integrations: {
    readPackageInfo: true
  }
};
const registerRoutes = router => {
  router.versioned.get({
    path: _constants2.EPM_API_ROUTES.CATEGORIES_PATTERN,
    fleetAuthz: READ_PACKAGE_INFO_AUTHZ
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetCategoriesRequestSchema
    }
  }, _handlers.getCategoriesHandler);
  router.versioned.get({
    path: _constants2.EPM_API_ROUTES.LIST_PATTERN,
    fleetAuthz: READ_PACKAGE_INFO_AUTHZ
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetPackagesRequestSchema
    }
  }, _handlers.getListHandler);
  router.versioned.get({
    path: _constants2.EPM_API_ROUTES.INSTALLED_LIST_PATTERN,
    fleetAuthz: READ_PACKAGE_INFO_AUTHZ
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetInstalledPackagesRequestSchema
    }
  }, _handlers.getInstalledListHandler);
  router.versioned.get({
    path: _constants2.EPM_API_ROUTES.LIMITED_LIST_PATTERN,
    fleetAuthz: READ_PACKAGE_INFO_AUTHZ
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: false
  }, _handlers.getLimitedListHandler);
  router.versioned.get({
    path: _constants2.EPM_API_ROUTES.STATS_PATTERN,
    fleetAuthz: READ_PACKAGE_INFO_AUTHZ
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetStatsRequestSchema
    }
  }, _handlers.getStatsHandler);
  router.versioned.get({
    path: _constants2.EPM_API_ROUTES.INPUTS_PATTERN,
    fleetAuthz: READ_PACKAGE_INFO_AUTHZ
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetInputsRequestSchema
    }
  }, _handlers.getInputsHandler);
  router.versioned.get({
    path: _constants2.EPM_API_ROUTES.FILEPATH_PATTERN,
    fleetAuthz: READ_PACKAGE_INFO_AUTHZ
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetFileRequestSchema
    }
  }, _file_handler.getFileHandler);
  router.versioned.get({
    path: _constants2.EPM_API_ROUTES.INFO_PATTERN,
    fleetAuthz: fleetAuthz => (0, _security.calculateRouteAuthz)(fleetAuthz, (0, _security.getRouteRequiredAuthz)('get', _constants2.EPM_API_ROUTES.INFO_PATTERN)).granted
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetInfoRequestSchema
    }
  }, _handlers.getInfoHandler);
  router.versioned.put({
    path: _constants2.EPM_API_ROUTES.INFO_PATTERN,
    fleetAuthz: {
      integrations: {
        writePackageSettings: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.UpdatePackageRequestSchema
    }
  }, _handlers.updatePackageHandler);
  router.versioned.post({
    path: _constants2.EPM_API_ROUTES.INSTALL_FROM_REGISTRY_PATTERN,
    fleetAuthz: INSTALL_PACKAGES_AUTHZ
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.InstallPackageFromRegistryRequestSchema
    }
  }, _handlers.installPackageFromRegistryHandler);
  router.versioned.post({
    path: _constants2.EPM_API_ROUTES.BULK_INSTALL_PATTERN,
    fleetAuthz: {
      integrations: {
        installPackages: true,
        upgradePackages: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.BulkInstallPackagesFromRegistryRequestSchema
    }
  }, _handlers.bulkInstallPackagesFromRegistryHandler);

  // Only allow upload for superuser
  router.versioned.post({
    path: _constants2.EPM_API_ROUTES.INSTALL_BY_UPLOAD_PATTERN,
    options: {
      body: {
        accepts: ['application/gzip', 'application/zip'],
        parse: false,
        maxBytes: MAX_FILE_SIZE_BYTES
      }
    },
    fleetAuthz: {
      integrations: {
        uploadPackages: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.InstallPackageByUploadRequestSchema
    }
  }, _handlers.installPackageByUploadHandler);
  router.versioned.post({
    path: _constants2.EPM_API_ROUTES.CUSTOM_INTEGRATIONS_PATTERN,
    fleetAuthz: INSTALL_PACKAGES_AUTHZ
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.CreateCustomIntegrationRequestSchema
    }
  }, _handlers.createCustomIntegrationHandler);
  router.versioned.delete({
    path: _constants2.EPM_API_ROUTES.DELETE_PATTERN,
    fleetAuthz: {
      integrations: {
        removePackages: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.DeletePackageRequestSchema
    }
  }, _handlers.deletePackageHandler);
  router.versioned.get({
    path: _constants2.EPM_API_ROUTES.VERIFICATION_KEY_ID,
    fleetAuthz: READ_PACKAGE_INFO_AUTHZ
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: false
  }, _handlers.getVerificationKeyIdHandler);
  router.versioned.get({
    path: _constants2.EPM_API_ROUTES.DATA_STREAMS_PATTERN,
    fleetAuthz: READ_PACKAGE_INFO_AUTHZ
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetDataStreamsRequestSchema
    }
  }, _handlers.getDataStreamsHandler);
  router.versioned.post({
    path: _constants2.EPM_API_ROUTES.BULK_ASSETS_PATTERN,
    fleetAuthz: READ_PACKAGE_INFO_AUTHZ
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetBulkAssetsRequestSchema
    }
  }, _handlers.getBulkAssetsHandler);

  // deprecated since 8.0
  // This endpoint should be marked as internal but the router selects this endpoint over the new GET one
  // For now keeping it public
  router.versioned.get({
    path: _constants2.EPM_API_ROUTES.INFO_PATTERN_DEPRECATED,
    fleetAuthz: fleetAuthz => (0, _security.calculateRouteAuthz)(fleetAuthz, (0, _security.getRouteRequiredAuthz)('get', _constants2.EPM_API_ROUTES.INFO_PATTERN_DEPRECATED)).granted
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetInfoRequestSchemaDeprecated
    }
  }, async (context, request, response) => {
    var _resp$payload;
    const newRequest = {
      ...request,
      params: (0, _registry.splitPkgKey)(request.params.pkgkey)
    };
    const resp = await (0, _handlers.getInfoHandler)(context, newRequest, response);
    if ((_resp$payload = resp.payload) !== null && _resp$payload !== void 0 && _resp$payload.item) {
      // returning item as well here, because pkgVersion is optional in new GET endpoint, and if not specified, the router selects the deprecated route
      return response.ok({
        body: {
          item: resp.payload.item,
          response: resp.payload.item
        }
      });
    }
    return resp;
  });
  router.versioned.put({
    path: _constants2.EPM_API_ROUTES.INFO_PATTERN_DEPRECATED,
    fleetAuthz: {
      integrations: {
        writePackageSettings: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.UpdatePackageRequestSchemaDeprecated
    }
  }, async (context, request, response) => {
    var _resp$payload2;
    const newRequest = {
      ...request,
      params: (0, _registry.splitPkgKey)(request.params.pkgkey)
    };
    const resp = await (0, _handlers.updatePackageHandler)(context, newRequest, response);
    if ((_resp$payload2 = resp.payload) !== null && _resp$payload2 !== void 0 && _resp$payload2.item) {
      return response.ok({
        body: {
          response: resp.payload.item
        }
      });
    }
    return resp;
  });

  // This endpoint should be marked as internal but the router selects this endpoint over the new POST
  router.versioned.post({
    path: _constants2.EPM_API_ROUTES.INSTALL_FROM_REGISTRY_PATTERN_DEPRECATED,
    fleetAuthz: INSTALL_PACKAGES_AUTHZ
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.InstallPackageFromRegistryRequestSchemaDeprecated
    }
  }, async (context, request, response) => {
    var _resp$payload3;
    const newRequest = {
      ...request,
      params: (0, _registry.splitPkgKey)(request.params.pkgkey),
      query: request.query
    };
    const resp = await (0, _handlers.installPackageFromRegistryHandler)(context, newRequest, response);
    if ((_resp$payload3 = resp.payload) !== null && _resp$payload3 !== void 0 && _resp$payload3.items) {
      return response.ok({
        body: {
          ...resp.payload,
          response: resp.payload.items
        }
      });
    }
    return resp;
  });
  router.versioned.delete({
    path: _constants2.EPM_API_ROUTES.DELETE_PATTERN_DEPRECATED,
    fleetAuthz: {
      integrations: {
        removePackages: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.DeletePackageRequestSchemaDeprecated
    }
  }, async (context, request, response) => {
    var _resp$payload4;
    const newRequest = {
      ...request,
      params: (0, _registry.splitPkgKey)(request.params.pkgkey)
    };
    const resp = await (0, _handlers.deletePackageHandler)(context, newRequest, response);
    if ((_resp$payload4 = resp.payload) !== null && _resp$payload4 !== void 0 && _resp$payload4.items) {
      return response.ok({
        body: {
          response: resp.payload.items
        }
      });
    }
    return resp;
  });

  // Update transforms with es-secondary-authorization headers,
  // append authorized_by to transform's _meta, and start transforms
  router.versioned.post({
    path: _constants2.EPM_API_ROUTES.REAUTHORIZE_TRANSFORMS,
    fleetAuthz: {
      ...INSTALL_PACKAGES_AUTHZ,
      packagePrivileges: {
        transform: {
          actions: {
            canStartStopTransform: {
              executePackageAction: true
            }
          }
        }
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.ReauthorizeTransformRequestSchema
    }
  }, _handlers.reauthorizeTransformsHandler);
};
exports.registerRoutes = registerRoutes;