"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _constants = require("../../../common/constants");
var _constants2 = require("../../constants");
var _types = require("../../types");
var _handlers = require("./handlers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = router => {
  // List - Fleet Server needs access to run setup
  router.versioned.get({
    path: _constants2.AGENT_POLICY_API_ROUTES.LIST_PATTERN,
    fleetAuthz: authz => {
      //  Allow to retrieve agent policies metadata (no full) for user with only read agents permissions
      return authz.fleet.readAgentPolicies || authz.fleet.readAgents;
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetAgentPoliciesRequestSchema
    }
  }, _handlers.getAgentPoliciesHandler);

  // Bulk GET
  router.versioned.post({
    path: _constants2.AGENT_POLICY_API_ROUTES.BULK_GET_PATTERN,
    fleetAuthz: {
      fleet: {
        readAgentPolicies: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.BulkGetAgentPoliciesRequestSchema
    }
  }, _handlers.bulkGetAgentPoliciesHandler);

  // Get one
  router.versioned.get({
    path: _constants2.AGENT_POLICY_API_ROUTES.INFO_PATTERN,
    fleetAuthz: authz => {
      //  Allow to retrieve agent policies metadata (no full) for user with only read agents permissions
      return authz.fleet.readAgentPolicies || authz.fleet.readAgents;
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetOneAgentPolicyRequestSchema
    }
  }, _handlers.getOneAgentPolicyHandler);

  // Create
  router.versioned.post({
    path: _constants2.AGENT_POLICY_API_ROUTES.CREATE_PATTERN,
    fleetAuthz: {
      fleet: {
        allAgentPolicies: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.CreateAgentPolicyRequestSchema
    }
  }, _handlers.createAgentPolicyHandler);

  // Update
  router.versioned.put({
    path: _constants2.AGENT_POLICY_API_ROUTES.UPDATE_PATTERN,
    fleetAuthz: {
      fleet: {
        allAgentPolicies: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.UpdateAgentPolicyRequestSchema
    }
  }, _handlers.updateAgentPolicyHandler);

  // Copy
  router.versioned.post({
    path: _constants2.AGENT_POLICY_API_ROUTES.COPY_PATTERN,
    fleetAuthz: {
      fleet: {
        allAgentPolicies: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.CopyAgentPolicyRequestSchema
    }
  }, _handlers.copyAgentPolicyHandler);

  // Delete
  router.versioned.post({
    path: _constants2.AGENT_POLICY_API_ROUTES.DELETE_PATTERN,
    fleetAuthz: {
      fleet: {
        allAgentPolicies: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.DeleteAgentPolicyRequestSchema
    }
  }, _handlers.deleteAgentPoliciesHandler);

  // Get one full agent policy
  router.versioned.get({
    path: _constants2.AGENT_POLICY_API_ROUTES.FULL_INFO_PATTERN,
    fleetAuthz: {
      fleet: {
        readAgentPolicies: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetFullAgentPolicyRequestSchema
    }
  }, _handlers.getFullAgentPolicy);

  // Download one full agent policy
  router.versioned.get({
    path: _constants2.AGENT_POLICY_API_ROUTES.FULL_INFO_DOWNLOAD_PATTERN,
    fleetAuthz: {
      fleet: {
        readAgentPolicies: true
      }
    },
    enableQueryVersion: true
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetFullAgentPolicyRequestSchema
    }
  }, _handlers.downloadFullAgentPolicy);

  // Get agent manifest
  router.versioned.get({
    path: _constants.K8S_API_ROUTES.K8S_INFO_PATTERN,
    fleetAuthz: {
      fleet: {
        readAgentPolicies: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetK8sManifestRequestSchema
    }
  }, _handlers.getK8sManifest);

  // Download agent manifest
  router.versioned.get({
    path: _constants.K8S_API_ROUTES.K8S_DOWNLOAD_PATTERN,
    fleetAuthz: {
      fleet: {
        readAgentPolicies: true
      }
    },
    enableQueryVersion: true
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetK8sManifestRequestSchema
    }
  }, _handlers.downloadK8sManifest);
};
exports.registerRoutes = registerRoutes;