"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgentUsage = exports.getAgentData = void 0;
var _common = require("../../common");
var _agents = _interopRequireWildcard(require("../services/agents"));
var AgentService = _agents;
var _services = require("../services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAgentUsage = async (soClient, esClient) => {
  // TODO: unsure if this case is possible at all.
  if (!soClient || !esClient) {
    return {
      total_enrolled: 0,
      healthy: 0,
      unhealthy: 0,
      offline: 0,
      inactive: 0,
      unenrolled: 0,
      total_all_statuses: 0,
      updating: 0
    };
  }
  const {
    total,
    inactive,
    online,
    error,
    offline,
    updating,
    unenrolled
  } = await AgentService.getAgentStatusForAgentPolicy(esClient, soClient);
  return {
    total_enrolled: total,
    healthy: online,
    unhealthy: error,
    offline,
    inactive,
    unenrolled,
    total_all_statuses: total + unenrolled,
    updating
  };
};
exports.getAgentUsage = getAgentUsage;
const DEFAULT_AGENT_DATA = {
  agent_checkin_status: {
    error: 0,
    degraded: 0
  },
  agents_per_policy: [],
  agents_per_version: [],
  agents_per_os: [],
  upgrade_details: []
};
const getAgentData = async (esClient, soClient, abortController) => {
  try {
    var _buckets2, _response$aggregation, _buckets3, _response$aggregation2, _buckets4, _response$aggregation3, _buckets5, _response$aggregation4;
    const transformLastCheckinStatusBuckets = resp => {
      var _buckets, _resp$aggregations;
      return ((_buckets = (resp === null || resp === void 0 ? void 0 : (_resp$aggregations = resp.aggregations) === null || _resp$aggregations === void 0 ? void 0 : _resp$aggregations.last_checkin_status).buckets) !== null && _buckets !== void 0 ? _buckets : []).reduce((acc, bucket) => {
        if (acc[bucket.key] !== undefined) acc[bucket.key] = bucket.doc_count;
        return acc;
      }, {
        error: 0,
        degraded: 0
      });
    };
    const response = await esClient.search({
      index: _common.AGENTS_INDEX,
      query: {
        bool: {
          filter: [{
            term: {
              active: 'true'
            }
          }]
        }
      },
      size: 0,
      aggs: {
        versions: {
          terms: {
            field: 'agent.version'
          }
        },
        last_checkin_status: {
          terms: {
            field: 'last_checkin_status'
          }
        },
        policies: {
          terms: {
            field: 'policy_id'
          }
        },
        os: {
          multi_terms: {
            terms: [{
              field: 'local_metadata.os.name.keyword'
            }, {
              field: 'local_metadata.os.version.keyword'
            }]
          }
        },
        upgrade_details: {
          multi_terms: {
            size: 1000,
            terms: [{
              field: 'upgrade_details.target_version.keyword'
            }, {
              field: 'upgrade_details.state'
            }, {
              field: 'upgrade_details.metadata.error_msg.keyword',
              missing: ''
            }]
          }
        }
      }
    }, {
      signal: abortController.signal
    });
    const agentsPerVersion = ((_buckets2 = (response === null || response === void 0 ? void 0 : (_response$aggregation = response.aggregations) === null || _response$aggregation === void 0 ? void 0 : _response$aggregation.versions).buckets) !== null && _buckets2 !== void 0 ? _buckets2 : []).map(bucket => ({
      version: bucket.key,
      count: bucket.doc_count,
      healthy: 0,
      unhealthy: 0,
      updating: 0,
      inactive: 0,
      unenrolled: 0,
      offline: 0
    }));
    const getAgentStatusesPerVersion = async version => {
      return await (0, _agents.getAgentStatusForAgentPolicy)(esClient, soClient, undefined, `agent.version:${version}`);
    };
    for (const agent of agentsPerVersion) {
      const {
        inactive,
        online: healthy,
        error: unhealthy,
        updating,
        offline,
        unenrolled
      } = await getAgentStatusesPerVersion(agent.version);
      agent.healthy = healthy;
      agent.unhealthy = unhealthy;
      agent.updating = updating;
      agent.inactive = inactive;
      agent.unenrolled = unenrolled;
      agent.offline = offline;
    }
    const statuses = transformLastCheckinStatusBuckets(response);
    const agentsPerPolicy = ((_buckets3 = (response === null || response === void 0 ? void 0 : (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.policies).buckets) !== null && _buckets3 !== void 0 ? _buckets3 : []).map(bucket => bucket.doc_count);
    const agentsPerOS = ((_buckets4 = (response === null || response === void 0 ? void 0 : (_response$aggregation3 = response.aggregations) === null || _response$aggregation3 === void 0 ? void 0 : _response$aggregation3.os).buckets) !== null && _buckets4 !== void 0 ? _buckets4 : []).map(bucket => ({
      name: bucket.key[0],
      version: bucket.key[1],
      count: bucket.doc_count
    }));
    const upgradeDetails = ((_buckets5 = (response === null || response === void 0 ? void 0 : (_response$aggregation4 = response.aggregations) === null || _response$aggregation4 === void 0 ? void 0 : _response$aggregation4.upgrade_details).buckets) !== null && _buckets5 !== void 0 ? _buckets5 : []).map(bucket => ({
      target_version: bucket.key[0],
      state: bucket.key[1],
      error_msg: bucket.key[2],
      agent_count: bucket.doc_count
    }));
    return {
      agent_checkin_status: statuses,
      agents_per_policy: agentsPerPolicy,
      agents_per_version: agentsPerVersion,
      agents_per_os: agentsPerOS,
      upgrade_details: upgradeDetails
    };
  } catch (error) {
    if (error.statusCode === 404) {
      _services.appContextService.getLogger().debug('Index .fleet-agents does not exist yet.');
    } else {
      throw error;
    }
    return DEFAULT_AGENT_DATA;
  }
};
exports.getAgentData = getAgentData;