"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentEnrollmentFlyoutData = useAgentEnrollmentFlyoutData;
var _react = require("react");
var _constants = require("../constants");
var _services = require("../services");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useAgentEnrollmentFlyoutData() {
  const {
    data: agentPoliciesData,
    isInitialRequest,
    isLoading: isLoadingAgentPolicies,
    resendRequest: refreshAgentPolicies
  } = (0, _use_request.useGetAgentPolicies)({
    page: 1,
    perPage: _constants.SO_SEARCH_LIMIT,
    full: true
  });
  const agentPolicies = (0, _react.useMemo)(() => {
    if (!isLoadingAgentPolicies) {
      var _agentPoliciesData$it;
      return ((_agentPoliciesData$it = agentPoliciesData === null || agentPoliciesData === void 0 ? void 0 : agentPoliciesData.items) !== null && _agentPoliciesData$it !== void 0 ? _agentPoliciesData$it : []).filter(policy => !(0, _services.policyHasFleetServer)(policy));
    }
    return [];
  }, [isLoadingAgentPolicies, agentPoliciesData === null || agentPoliciesData === void 0 ? void 0 : agentPoliciesData.items]);
  return {
    agentPolicies,
    refreshAgentPolicies,
    isLoadingInitialAgentPolicies: isInitialRequest && isLoadingAgentPolicies,
    isLoadingAgentPolicies
  };
}